"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useListArtifact = useListArtifact;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _constants = require("../../common/constants");
var _utils = require("../../common/utils");
var _constants2 = require("../../../../common/endpoint/service/artifacts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_OPTIONS = Object.freeze({});
function useListArtifact(exceptionListApiClient, options = DEFAULT_OPTIONS, searchableFields = _constants2.DEFAULT_EXCEPTION_LIST_ITEM_SEARCHABLE_FIELDS, customQueryOptions, customQueryIds = []) {
  const {
    filter = '',
    page = _constants.MANAGEMENT_DEFAULT_PAGE + 1,
    perPage = _constants.MANAGEMENT_DEFAULT_PAGE_SIZE,
    policies = [],
    excludedPolicies = []
  } = options;
  const filterKuery = (0, _react.useMemo)(() => {
    return (0, _utils.parsePoliciesAndFilterToKql)({
      kuery: (0, _utils.parseQueryFilterToKQL)(filter, searchableFields),
      policies,
      excludedPolicies
    });
  }, [filter, searchableFields, policies, excludedPolicies]);
  return (0, _reactQuery.useQuery)([...customQueryIds, 'list', exceptionListApiClient, filterKuery, page, perPage], async () => {
    const result = await exceptionListApiClient.find({
      filter: filterKuery,
      perPage,
      page,
      sortField: _constants.MANAGEMENT_DEFAULT_SORT_FIELD,
      sortOrder: _constants.MANAGEMENT_DEFAULT_SORT_ORDER
    });
    return result;
  }, customQueryOptions);
}