"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardCompressedHeaderLayout = exports.CardCompressedHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _card_expand_button = require("./card_expand_button");
var _text_value_display = require("./text_value_display");
var _effect_scope = require("./effect_scope");
var _card_actions_flex_item = require("./card_actions_flex_item");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_collapsed_css_class_names = require("../hooks/use_collapsed_css_class_names");
var _use_policy_nav_links = require("../hooks/use_policy_nav_links");
var _description_field = require("./description_field");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CardCompressedHeader = exports.CardCompressedHeader = /*#__PURE__*/(0, _react.memo)(({
  artifact,
  onExpandCollapse,
  policies,
  actions,
  expanded = false,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const policyNavLinks = (0, _use_policy_nav_links.usePolicyNavLinks)(artifact, policies);
  const handleExpandCollapseClick = (0, _react.useCallback)(() => {
    onExpandCollapse();
  }, [onExpandCollapse]);
  return /*#__PURE__*/_react.default.createElement(CardCompressedHeaderLayout, {
    "data-test-subj": dataTestSubj,
    expanded: expanded,
    expandToggle: /*#__PURE__*/_react.default.createElement(_card_expand_button.CardExpandButton, {
      expanded: expanded,
      onClick: handleExpandCollapseClick,
      "data-test-subj": getTestId('expandCollapse')
    }),
    name: /*#__PURE__*/_react.default.createElement(_text_value_display.TextValueDisplay, {
      bold: true,
      truncate: !expanded,
      withTooltip: !expanded
    }, artifact.name),
    description: /*#__PURE__*/_react.default.createElement(_description_field.DescriptionField, {
      truncate: !expanded,
      withTooltip: !expanded
    }, artifact.description),
    effectScope: /*#__PURE__*/_react.default.createElement(_effect_scope.EffectScope, {
      policies: policyNavLinks,
      "data-test-subj": getTestId('effectScope')
    }),
    actionMenu: /*#__PURE__*/_react.default.createElement(_card_actions_flex_item.CardActionsFlexItem, {
      actions: actions,
      "data-test-subj": getTestId('actions')
    })
  });
});
CardCompressedHeader.displayName = 'CardCompressedHeader';
const ButtonIconPlaceHolder = _styled.default.div`
  display: inline-block;
  // Sizes below should match that of the Eui's Button Icon, so that it holds the same space.
  width: ${({
  theme
}) => theme.euiTheme.size.l};
  height: ${({
  theme
}) => theme.euiTheme.size.l};
`;
const StyledEuiFlexGroup = (0, _styled.default)(_eui.EuiFlexGroup)`
  &.flushTop,
  .flushTop {
    padding-top: 0;
    margin-top: 0;
  }
`;

/**
 * Layout used for the compressed card header. Used also in the ArtifactGrid for creating the grid header row
 */

const CardCompressedHeaderLayout = exports.CardCompressedHeaderLayout = /*#__PURE__*/(0, _react.memo)(({
  expanded,
  name,
  expandToggle,
  effectScope,
  actionMenu,
  description,
  'data-test-subj': dataTestSubj,
  flushTop
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const cssClassNames = (0, _use_collapsed_css_class_names.useCollapsedCssClassNames)(expanded);
  const flushTopCssClassname = flushTop ? ' flushTop' : '';
  return /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    "data-test-subj": dataTestSubj,
    className: flushTopCssClassname
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: flushTopCssClassname,
    "data-test-subj": getTestId('expandCollapseHolder')
  }, expandToggle), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: cssClassNames + flushTopCssClassname
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    className: flushTopCssClassname
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    className: cssClassNames + flushTopCssClassname,
    "data-test-subj": getTestId('titleHolder')
  }, name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    className: cssClassNames + flushTopCssClassname,
    "data-test-subj": getTestId('descriptionHolder')
  }, description), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    "data-test-subj": getTestId('effectScopeHolder'),
    className: flushTopCssClassname
  }, effectScope))), actionMenu === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": getTestId('cardActionsPlaceholder'),
    className: flushTopCssClassname
  }, /*#__PURE__*/_react.default.createElement(ButtonIconPlaceHolder, null)) : actionMenu);
});
CardCompressedHeaderLayout.displayName = 'CardCompressedHeaderLayout';