"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutLoading = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Use this when you need to show a loading state in the flyout
 */
const FlyoutLoading = ({
  'data-test-subj': dataTestSubj = _test_ids.FLYOUT_LOADING_TEST_ID
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  css: (0, _react2.css)`
      align-items: center;
      justify-content: center;
    `
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  size: "xxl",
  "data-test-subj": dataTestSubj
}));
exports.FlyoutLoading = FlyoutLoading;