"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _i18n = require("@kbn/i18n");
var _integration_icon = require("../common/integration_icon");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SIEM_BADGE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.integrations.siemBadge', {
  defaultMessage: 'SIEM'
});
const MIN_WIDTH = 275; // px
const INTEGRATIONS_BASE_PATH = '/app/integrations';
const INTEGRATION_DETAILS_PAGE = 'integration_details_overview';
/**
 * Rendered on the alert summary landing page, when no integrations have been installed.
 * The card is clickable and will navigate the user to the integration's details page.
 */
const IntegrationCard = exports.IntegrationCard = /*#__PURE__*/(0, _react.memo)(({
  integration,
  'data-test-subj': dataTestSubj
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const iconStyle = (0, _react.useMemo)(() => ({
    marginInlineEnd: euiTheme.size.base
  }), [euiTheme]);
  const {
    services: {
      application
    }
  } = (0, _kibana.useKibana)();
  const {
    getHref
  } = (0, _public.useLink)();
  const onClick = (0, _react.useCallback)(() => {
    const url = getHref(INTEGRATION_DETAILS_PAGE, {
      pkgkey: `${integration.name}-${integration.version}`,
      ...(integration.integration ? {
        integration: integration.integration
      } : {})
    });
    application.navigateToApp(_common.INTEGRATIONS_PLUGIN_ID, {
      path: url.slice(INTEGRATIONS_BASE_PATH.length)
    });
  }, [application, getHref, integration.integration, integration.name, integration.version]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    css: (0, _react2.css)`
          min-width: ${MIN_WIDTH}px;
        `,
    "data-test-subj": dataTestSubj,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, SIEM_BADGE),
    display: "plain",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement("div", {
      style: iconStyle
    }, /*#__PURE__*/_react.default.createElement(_integration_icon.IntegrationIcon, {
      "data-test-subj": dataTestSubj,
      iconSize: "xl",
      integration: integration
    })),
    layout: "horizontal",
    onClick: onClick,
    titleSize: "xs",
    title: integration.title
  });
});
IntegrationCard.displayName = 'IntegrationCard';