"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoverageOverviewLegend = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../constants");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_coverage_colors = require("../use_coverage_colors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LegendLabel = ({
  label,
  color
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFacetButton, {
  size: "xs",
  element: "span",
  css: {
    padding: 0
  },
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    css: {
      background: color,
      boxShadow: color != null ? 'none' : undefined
    },
    label: label,
    iconType: "empty",
    size: "s"
  })
}, label);
const CoverageOverviewLegend = () => {
  const {
    coverageColors
  } = (0, _use_coverage_colors.useCoverageColors)();
  const thresholds = (0, _react.useMemo)(() => coverageColors.map(({
    threshold,
    backgroundColor
  }, index, thresholdsMap) => /*#__PURE__*/_react.default.createElement(LegendLabel, {
    key: index,
    label: `${index === 0 ? `\u003E${threshold}` : `${threshold}-${thresholdsMap[index - 1].threshold}`} ${i18n.CoverageOverviewLegendRulesLabel}`,
    color: backgroundColor
  })), [coverageColors]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: {
      maxWidth: `${_constants.coverageOverviewLegendWidth}px`
    },
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.CoverageOverviewLegendTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("small", null, i18n.CoverageOverviewLegendSubtitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    wrap: true
  }, thresholds, /*#__PURE__*/_react.default.createElement(LegendLabel, {
    label: `0 ${i18n.CoverageOverviewLegendRulesLabel}`
  })));
};
exports.CoverageOverviewLegend = CoverageOverviewLegend;