"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRulesColumns = exports.useRuleExecutionStatusColumn = exports.useMonitoringColumns = exports.useGapDurationColumn = exports.useEnabledColumn = exports.TOTAL_UNFILLED_DURATION_COLUMN = exports.SEARCH_DURATION_COLUMN = exports.RuleLink = exports.RULE_NAME_COLUMN = exports.LAST_EXECUTION_COLUMN = exports.INDEXING_DURATION_COLUMN = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _rules_table_empty_column_name = require("./rules_table_empty_column_name");
var _constants = require("../../../../../common/constants");
var _helpers = require("../../../../../common/machine_learning/helpers");
var _empty_value = require("../../../../common/components/empty_value");
var _rule_snooze_badge = require("../../../rule_management/components/rule_snooze_badge");
var _formatted_date = require("../../../../common/components/formatted_date");
var _links = require("../../../../common/components/links");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _popover_items = require("../../../../common/components/popover_items");
var _kibana = require("../../../../common/lib/kibana");
var _privileges = require("../../../../common/utils/privileges");
var _integrations_popover = require("../../../common/components/related_integrations/integrations_popover");
var _rule_execution_status = require("../../../common/components/rule_execution_status");
var _rule_switch = require("../../../common/components/rule_switch");
var _severity_badge = require("../../../../common/components/severity_badge");
var i18n = _interopRequireWildcard(require("../../../common/translations"));
var _use_rule_details_tabs = require("../../../rule_details_ui/pages/rule_details/use_rule_details_tabs");
var _popover_tooltip = require("./popover_tooltip");
var _rules_table_context = require("./rules_table/rules_table_context");
var _table_header_tooltip_cell = require("./table_header_tooltip_cell");
var _use_has_actions_privileges = require("./use_has_actions_privileges");
var _use_has_ml_permissions = require("./use_has_ml_permissions");
var _use_rules_table_actions = require("./use_rules_table_actions");
var _ml_rule_warning_popover = require("../ml_rule_warning_popover/ml_rule_warning_popover");
var _helpers2 = require("../../../common/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadingActionsSet = new Set(['disable', 'enable', 'edit', 'delete', 'run', 'fill_gaps']);
const useEnabledColumn = ({
  hasCRUDPermissions,
  startMlJobs
}) => {
  const hasMlPermissions = (0, _use_has_ml_permissions.useHasMlPermissions)();
  const hasActionsPrivileges = (0, _use_has_actions_privileges.useHasActionsPrivileges)();
  const {
    loadingRulesAction,
    loadingRuleIds
  } = (0, _rules_table_context.useRulesTableContext)().state;
  const loadingIds = (0, _react.useMemo)(() => loadingActionsSet.has(loadingRulesAction !== null && loadingRulesAction !== void 0 ? loadingRulesAction : '') ? loadingRuleIds : [], [loadingRuleIds, loadingRulesAction]);
  return (0, _react.useMemo)(() => ({
    field: 'enabled',
    name: i18n.COLUMN_ENABLE,
    render: (_, rule) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: (0, _privileges.explainLackOfPermission)(rule, hasMlPermissions, hasActionsPrivileges, hasCRUDPermissions)
    }, /*#__PURE__*/_react.default.createElement(_rule_switch.RuleSwitch, {
      id: rule.id,
      enabled: rule.enabled,
      startMlJobsIfNeeded: () => startMlJobs((0, _helpers2.getMachineLearningJobId)(rule)),
      isDisabled: !(0, _privileges.canEditRuleWithActions)(rule, hasActionsPrivileges) || !hasCRUDPermissions || (0, _helpers.isMlRule)(rule.type) && !hasMlPermissions,
      isLoading: loadingIds.includes(rule.id),
      ruleName: rule.name
    })),
    width: '95px',
    sortable: true
  }), [hasMlPermissions, hasActionsPrivileges, hasCRUDPermissions, loadingIds, startMlJobs]);
};
exports.useEnabledColumn = useEnabledColumn;
const useRuleSnoozeColumn = () => {
  return (0, _react.useMemo)(() => ({
    field: 'snooze',
    name: i18n.COLUMN_SNOOZE,
    render: (_, rule) => /*#__PURE__*/_react.default.createElement(_rule_snooze_badge.RuleSnoozeBadge, {
      ruleId: rule.id
    }),
    width: '100px',
    sortable: false
  }), []);
};
const RuleLink = ({
  name,
  id
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: name,
    anchorClassName: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
    "data-test-subj": "ruleName",
    deepLinkId: _constants.SecurityPageName.rules,
    path: (0, _redirect_to_detection_engine.getRuleDetailsTabUrl)(id, _use_rule_details_tabs.RuleDetailTabs.alerts)
  }, name));
};
exports.RuleLink = RuleLink;
const RULE_NAME_COLUMN = exports.RULE_NAME_COLUMN = {
  field: 'name',
  name: i18n.COLUMN_RULE,
  render: (value, item) => /*#__PURE__*/_react.default.createElement(RuleLink, {
    id: item.id,
    name: value
  }),
  sortable: true,
  truncateText: true,
  width: '38%'
};
const useRuleExecutionStatusColumn = ({
  sortable,
  width,
  isLoadingJobs,
  mlJobs
}) => {
  return (0, _react.useMemo)(() => ({
    field: 'execution_summary.last_execution.status',
    name: i18n.COLUMN_LAST_RESPONSE,
    render: (value, item) => {
      var _item$execution_summa;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_rule_execution_status.RuleStatusBadge, {
        status: value,
        message: (_item$execution_summa = item.execution_summary) === null || _item$execution_summa === void 0 ? void 0 : _item$execution_summa.last_execution.message
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_ml_rule_warning_popover.MlRuleWarningPopover, {
        rule: item,
        loadingJobs: isLoadingJobs,
        jobs: mlJobs
      })));
    },
    sortable,
    truncateText: true,
    width
  }), [isLoadingJobs, mlJobs, sortable, width]);
};
exports.useRuleExecutionStatusColumn = useRuleExecutionStatusColumn;
const TAGS_COLUMN = {
  field: 'tags',
  name: /*#__PURE__*/_react.default.createElement(_rules_table_empty_column_name.RulesTableEmptyColumnName, {
    name: i18n.COLUMN_TAGS
  }),
  align: 'center',
  render: tags => {
    if (tags == null || tags.length === 0) {
      return null;
    }
    const renderItem = (tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      key: `${tag}-${i}`,
      "data-test-subj": "tag"
    }, tag);
    return /*#__PURE__*/_react.default.createElement(_popover_items.PopoverItems, {
      items: tags,
      popoverTitle: i18n.COLUMN_TAGS,
      popoverButtonTitle: tags.length.toString(),
      popoverButtonIcon: "tag",
      dataTestPrefix: "tags",
      renderItem: renderItem
    });
  },
  width: '65px',
  truncateText: true
};
const INTEGRATIONS_COLUMN = {
  field: 'related_integrations',
  name: /*#__PURE__*/_react.default.createElement(_rules_table_empty_column_name.RulesTableEmptyColumnName, {
    name: i18n.COLUMN_INTEGRATIONS
  }),
  align: 'center',
  render: integrations => {
    if (integrations == null || integrations.length === 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_integrations_popover.IntegrationsPopover, {
      relatedIntegrations: integrations
    });
  },
  width: '70px',
  truncateText: true
};
const MODIFIED_COLUMN = {
  field: 'rule_source',
  name: /*#__PURE__*/_react.default.createElement(_rules_table_empty_column_name.RulesTableEmptyColumnName, {
    name: i18n.COLUMN_MODIFIED
  }),
  align: 'center',
  render: ruleSource => {
    if (ruleSource == null || ruleSource.type === 'internal' || ruleSource.type === 'external' && ruleSource.is_customized === false) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.MODIFIED_TOOLTIP
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      tabIndex: 0,
      color: "hollow",
      "data-test-subj": "rulesTableModifiedColumnBadge",
      "aria-label": i18n.MODIFIED_LABEL
    }, i18n.MODIFIED_LABEL));
  },
  width: '90px',
  truncateText: true
};
const LAST_EXECUTION_COLUMN = exports.LAST_EXECUTION_COLUMN = {
  field: 'execution_summary.last_execution.date',
  name: i18n.COLUMN_LAST_COMPLETE_RUN,
  render: value => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      "data-test-subj": "ruleLastRun"
    }, value == null ? (0, _empty_value.getEmptyTagValue)() : /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
      tooltipFieldName: i18n.COLUMN_LAST_COMPLETE_RUN,
      relativeThresholdInHrs: _constants.DEFAULT_RELATIVE_DATE_THRESHOLD,
      value: value,
      tooltipAnchorClassName: "eui-textTruncate"
    }));
  },
  sortable: true,
  truncateText: true,
  width: '16%'
};
const useActionsColumn = ({
  showExceptionsDuplicateConfirmation,
  showManualRuleRunConfirmation,
  confirmDeletion
}) => {
  const actions = (0, _use_rules_table_actions.useRulesTableActions)({
    showExceptionsDuplicateConfirmation,
    showManualRuleRunConfirmation,
    confirmDeletion
  });
  return (0, _react.useMemo)(() => ({
    actions,
    width: '40px'
  }), [actions]);
};
const useRulesColumns = ({
  hasCRUDPermissions,
  isLoadingJobs,
  mlJobs,
  startMlJobs,
  showExceptionsDuplicateConfirmation,
  showManualRuleRunConfirmation,
  confirmDeletion
}) => {
  const actionsColumn = useActionsColumn({
    showExceptionsDuplicateConfirmation,
    showManualRuleRunConfirmation,
    confirmDeletion
  });
  const [showRelatedIntegrations] = (0, _kibana.useUiSetting$)(_constants.SHOW_RELATED_INTEGRATIONS_SETTING);
  const enabledColumn = useEnabledColumn({
    hasCRUDPermissions,
    isLoadingJobs,
    mlJobs,
    startMlJobs
  });
  const executionStatusColumn = useRuleExecutionStatusColumn({
    sortable: true,
    width: '16%',
    isLoadingJobs,
    mlJobs
  });
  const snoozeColumn = useRuleSnoozeColumn();
  return (0, _react.useMemo)(() => [RULE_NAME_COLUMN, MODIFIED_COLUMN, ...(showRelatedIntegrations ? [INTEGRATIONS_COLUMN] : []), TAGS_COLUMN, {
    field: 'risk_score',
    name: i18n.COLUMN_RISK_SCORE,
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "riskScore",
      size: "s"
    }, value),
    sortable: true,
    truncateText: true,
    width: '85px'
  }, {
    field: 'severity',
    name: i18n.COLUMN_SEVERITY,
    render: value => /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
      value: value
    }),
    sortable: true,
    truncateText: true,
    width: '12%'
  }, LAST_EXECUTION_COLUMN, executionStatusColumn, {
    field: 'updated_at',
    name: i18n.COLUMN_LAST_UPDATE,
    render: value => {
      return value == null ? (0, _empty_value.getEmptyTagValue)() : /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
        tooltipFieldName: i18n.COLUMN_LAST_UPDATE,
        relativeThresholdInHrs: _constants.DEFAULT_RELATIVE_DATE_THRESHOLD,
        value: value,
        tooltipAnchorClassName: "eui-textTruncate"
      });
    },
    sortable: true,
    width: '18%',
    truncateText: true
  }, snoozeColumn, enabledColumn, ...(hasCRUDPermissions ? [actionsColumn] : [])], [showRelatedIntegrations, executionStatusColumn, snoozeColumn, enabledColumn, hasCRUDPermissions, actionsColumn]);
};
exports.useRulesColumns = useRulesColumns;
const INDEXING_DURATION_COLUMN = exports.INDEXING_DURATION_COLUMN = {
  field: 'execution_summary.last_execution.metrics.total_indexing_duration_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_INDEXING_TIMES,
    tooltipContent: i18n.COLUMN_INDEXING_TIMES_TOOLTIP
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "total_indexing_duration_ms",
    size: "s"
  }, value != null ? value.toFixed() : (0, _empty_value.getEmptyTagValue)()),
  sortable: true,
  truncateText: true,
  width: '16%'
};
const SEARCH_DURATION_COLUMN = exports.SEARCH_DURATION_COLUMN = {
  field: 'execution_summary.last_execution.metrics.total_search_duration_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_QUERY_TIMES,
    tooltipContent: i18n.COLUMN_QUERY_TIMES_TOOLTIP
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "total_search_duration_ms",
    size: "s"
  }, value != null ? value.toFixed() : (0, _empty_value.getEmptyTagValue)()),
  sortable: true,
  truncateText: true,
  width: '14%'
};
const useGapDurationColumn = () => {
  const docLinks = (0, _kibana.useKibana)().services.docLinks;
  return {
    field: 'execution_summary.last_execution.metrics.execution_gap_duration_s',
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.COLUMN_GAP,
      customTooltip: /*#__PURE__*/_react.default.createElement("div", {
        style: {
          maxWidth: '20px'
        }
      }, /*#__PURE__*/_react.default.createElement(_popover_tooltip.PopoverTooltip, {
        columnName: i18n.COLUMN_GAP,
        anchorColor: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        css: {
          width: 300
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Duration of most recent gap in Rule execution. Adjust Rule look-back or {seeDocs} for mitigating gaps.",
        id: "xpack.securitySolution.detectionEngine.rules.allRules.columns.gapTooltip",
        values: {
          seeDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: `${docLinks.links.siem.troubleshootGaps}`,
            target: "_blank"
          }, i18n.COLUMN_GAP_TOOLTIP_SEE_DOCUMENTATION)
        }
      }))))
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "gap",
      size: "s"
    }, value != null ? _moment.default.duration(value, 'seconds').humanize() : (0, _empty_value.getEmptyTagValue)()),
    sortable: true,
    truncateText: true,
    width: '14%'
  };
};
exports.useGapDurationColumn = useGapDurationColumn;
const TOTAL_UNFILLED_DURATION_COLUMN = exports.TOTAL_UNFILLED_DURATION_COLUMN = {
  field: 'gap_info.total_unfilled_duration_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_TOTAL_UNFILLED_GAPS_DURATION,
    tooltipContent: i18n.COLUMN_TOTAL_UNFILLED_GAPS_DURATION_TOOLTIP
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "gap_info",
    size: "s"
  }, value != null && value > 0 ? _moment.default.duration(value, 'ms').humanize() : (0, _empty_value.getEmptyTagValue)()),
  sortable: false,
  truncateText: true,
  width: '14%'
};
const useMonitoringColumns = ({
  hasCRUDPermissions,
  isLoadingJobs,
  mlJobs,
  startMlJobs,
  showExceptionsDuplicateConfirmation,
  showManualRuleRunConfirmation,
  confirmDeletion
}) => {
  const actionsColumn = useActionsColumn({
    showExceptionsDuplicateConfirmation,
    showManualRuleRunConfirmation,
    confirmDeletion
  });
  const [showRelatedIntegrations] = (0, _kibana.useUiSetting$)(_constants.SHOW_RELATED_INTEGRATIONS_SETTING);
  const enabledColumn = useEnabledColumn({
    hasCRUDPermissions,
    isLoadingJobs,
    mlJobs,
    startMlJobs
  });
  const executionStatusColumn = useRuleExecutionStatusColumn({
    sortable: true,
    width: '12%',
    isLoadingJobs,
    mlJobs
  });
  const gapDurationColumn = useGapDurationColumn();
  return (0, _react.useMemo)(() => [{
    ...RULE_NAME_COLUMN,
    width: '28%'
  }, MODIFIED_COLUMN, ...(showRelatedIntegrations ? [INTEGRATIONS_COLUMN] : []), TAGS_COLUMN, INDEXING_DURATION_COLUMN, SEARCH_DURATION_COLUMN, gapDurationColumn, TOTAL_UNFILLED_DURATION_COLUMN, executionStatusColumn, LAST_EXECUTION_COLUMN, enabledColumn, ...(hasCRUDPermissions ? [actionsColumn] : [])], [actionsColumn, enabledColumn, executionStatusColumn, gapDurationColumn, hasCRUDPermissions, showRelatedIntegrations]);
};
exports.useMonitoringColumns = useMonitoringColumns;