"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertSuppression = void 0;
var _react = require("react");
var _utils = require("../../../../common/detection_engine/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertSuppression = ruleType => {
  const isSuppressionEnabledForRuleType = (0, _react.useCallback)(() => {
    if (!ruleType) {
      return false;
    }
    return (0, _utils.isSuppressibleAlertRule)(ruleType);
  }, [ruleType]);
  return {
    isSuppressionEnabled: isSuppressionEnabledForRuleType()
  };
};
exports.useAlertSuppression = useAlertSuppression;