"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldToDisplayNameMap = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Used when fields have different display names or formats than their corresponding rule object fields
 */
const fieldToDisplayNameMap = exports.fieldToDisplayNameMap = {
  alert_suppression: _translations.ALERT_SUPPRESSION_FIELD_LABEL,
  data_source: _translations.DATA_SOURCE_FIELD_LABEL,
  note: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRuleFields.noteLabel', {
    defaultMessage: 'Investigation guide'
  }),
  severity_mapping: _translations.SEVERITY_MAPPING_FIELD_LABEL,
  risk_score_mapping: _translations.RISK_SCORE_MAPPING_FIELD_LABEL,
  references: _translations.REFERENCES_FIELD_LABEL,
  threat_indicator_path: _translations.THREAT_INDICATOR_PATH_LABEL,
  index_patterns: _translations.INDEX_FIELD_LABEL,
  investigation_fields: _translations.INVESTIGATION_FIELDS_FIELD_LABEL,
  data_view_id: _translations.DATA_VIEW_ID_FIELD_LABEL,
  threat: _translations.THREAT_FIELD_LABEL,
  eql_query: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRuleFields.eqlQueryLabel', {
    defaultMessage: 'EQL query'
  }),
  kql_query: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRuleFields.kqlQueryLabel', {
    defaultMessage: 'KQL query'
  }),
  threat_query: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRuleFields.threatQueryLabel', {
    defaultMessage: 'Indicator index query'
  }),
  esql_query: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRuleFields.esqlQueryLabel', {
    defaultMessage: 'ESQL query'
  }),
  anomaly_threshold: _translations.ANOMALY_THRESHOLD_FIELD_LABEL,
  machine_learning_job_id: _translations.MACHINE_LEARNING_JOB_ID_FIELD_LABEL,
  threat_index: _translations.THREAT_INDEX_FIELD_LABEL,
  threat_mapping: _translations.THREAT_MAPPING_FIELD_LABEL,
  history_window_start: _translations.HISTORY_WINDOW_SIZE_FIELD_LABEL
};