"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBackfillRowsFromResponse = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getScheduledEntryAmount = backfill => {
  var _backfill$schedule, _backfill$schedule$le, _backfill$schedule2;
  return backfill === null || backfill === void 0 ? void 0 : (_backfill$schedule = backfill.schedule) === null || _backfill$schedule === void 0 ? void 0 : _backfill$schedule.reduce((acc, scheduledEntry) => {
    var _acc$scheduledEntry$s;
    return {
      ...acc,
      [scheduledEntry.status]: ((_acc$scheduledEntry$s = acc[scheduledEntry.status]) !== null && _acc$scheduledEntry$s !== void 0 ? _acc$scheduledEntry$s : 0) + 1
    };
  }, {
    total: (_backfill$schedule$le = backfill === null || backfill === void 0 ? void 0 : (_backfill$schedule2 = backfill.schedule) === null || _backfill$schedule2 === void 0 ? void 0 : _backfill$schedule2.length) !== null && _backfill$schedule$le !== void 0 ? _backfill$schedule$le : 0,
    complete: 0,
    running: 0,
    pending: 0,
    error: 0,
    timeout: 0
  });
};
const getBackfillRowsFromResponse = backfills => {
  var _backfills$map;
  const backfillRows = (_backfills$map = backfills === null || backfills === void 0 ? void 0 : backfills.map(backfill => ({
    ...backfill,
    ...getScheduledEntryAmount(backfill)
  }))) !== null && _backfills$map !== void 0 ? _backfills$map : [];
  return backfillRows;
};
exports.getBackfillRowsFromResponse = getBackfillRowsFromResponse;