"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyTemplateVarsForm = exports.PolicyTemplateInputSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/fleet-plugin/public");
var _utils = require("./utils");
var _asset_boxed_radio_group = require("./asset_boxed_radio_group");
var _azure_credentials_form = require("./azure_credentials_form/azure_credentials_form");
var _azure_credentials_form_agentless = require("./azure_credentials_form/azure_credentials_form_agentless");
var _aws_credentials_form = require("./aws_credentials_form/aws_credentials_form");
var _aws_credentials_form_agentless = require("./aws_credentials_form/aws_credentials_form_agentless");
var _gcp_credential_form = require("./gcp_credentials_form/gcp_credential_form");
var _gcp_credentials_form_agentless = require("./gcp_credentials_form/gcp_credentials_form_agentless");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyTemplateVarsForm = ({
  input,
  setupTechnology,
  newPolicy,
  updatePolicy,
  packageInfo,
  disabled,
  isEditPage,
  hasInvalidRequiredVars,
  showCloudConnectors
}) => {
  const isAgentless = setupTechnology === _public.SetupTechnology.AGENTLESS;
  switch (input.type) {
    case 'cloudbeat/asset_inventory_aws':
      if (isAgentless) {
        return /*#__PURE__*/_react.default.createElement(_aws_credentials_form_agentless.AwsCredentialsFormAgentless, {
          newPolicy: newPolicy,
          setupTechnology: setupTechnology,
          updatePolicy: updatePolicy,
          isEditPage: isEditPage,
          packageInfo: packageInfo,
          hasInvalidRequiredVars: hasInvalidRequiredVars,
          input: input,
          showCloudConnectors: showCloudConnectors
        });
      }
      return /*#__PURE__*/_react.default.createElement(_aws_credentials_form.AwsCredentialsForm, {
        newPolicy: newPolicy,
        updatePolicy: updatePolicy,
        packageInfo: packageInfo,
        disabled: disabled,
        hasInvalidRequiredVars: hasInvalidRequiredVars,
        input: input
      });
    case 'cloudbeat/asset_inventory_gcp':
      if (isAgentless) {
        return /*#__PURE__*/_react.default.createElement(_gcp_credentials_form_agentless.GcpCredentialsFormAgentless, {
          newPolicy: newPolicy,
          updatePolicy: updatePolicy,
          packageInfo: packageInfo,
          disabled: disabled,
          hasInvalidRequiredVars: hasInvalidRequiredVars,
          input: input
        });
      }
      return /*#__PURE__*/_react.default.createElement(_gcp_credential_form.GcpCredentialsForm, {
        input: input,
        newPolicy: newPolicy,
        updatePolicy: updatePolicy,
        packageInfo: packageInfo,
        disabled: disabled,
        hasInvalidRequiredVars: hasInvalidRequiredVars,
        isEditPage: isEditPage
      });
    case 'cloudbeat/asset_inventory_azure':
      if (isAgentless) {
        return /*#__PURE__*/_react.default.createElement(_azure_credentials_form_agentless.AzureCredentialsFormAgentless, {
          newPolicy: newPolicy,
          updatePolicy: updatePolicy,
          packageInfo: packageInfo,
          hasInvalidRequiredVars: hasInvalidRequiredVars,
          input: input,
          disabled: disabled
        });
      }
      return /*#__PURE__*/_react.default.createElement(_azure_credentials_form.AzureCredentialsForm, {
        input: input,
        newPolicy: newPolicy,
        updatePolicy: updatePolicy,
        packageInfo: packageInfo,
        disabled: disabled,
        hasInvalidRequiredVars: hasInvalidRequiredVars
      });
    default:
      return null;
  }
};
exports.PolicyTemplateVarsForm = PolicyTemplateVarsForm;
const PolicyTemplateInputSelector = ({
  input,
  disabled,
  setInput
}) => {
  const baseOptions = (0, _utils.getPolicyTemplateInputOptions)();
  const options = baseOptions.map(option => ({
    ...option,
    disabled: option.disabled || disabled,
    label: option.label,
    icon: option.icon
  }));
  return /*#__PURE__*/_react.default.createElement(_asset_boxed_radio_group.RadioGroup, {
    disabled: disabled,
    idSelected: input.type,
    options: options,
    onChange: inputType => setInput(inputType),
    size: "m",
    name: "policyTemplateInput"
  });
};
exports.PolicyTemplateInputSelector = PolicyTemplateInputSelector;