"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUISettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerUISettings = ({
  uiSettings
}) => {
  uiSettings.register({
    [_constants.ONECHAT_MCP_SERVER_UI_SETTING_ID]: {
      description: _i18n.i18n.translate('xpack.onechat.uiSettings.mcpServer.description', {
        defaultMessage: 'Enables MCP server with access to tools.'
      }),
      name: _i18n.i18n.translate('xpack.onechat.uiSettings.mcpServer.name', {
        defaultMessage: 'MCP Server'
      }),
      schema: _configSchema.schema.boolean(),
      value: false,
      readonly: true,
      readonlyMode: 'ui'
    },
    [_constants.ONECHAT_UI_SETTING_ID]: {
      description: _i18n.i18n.translate('xpack.onechat.uiSettings.chatUI.description', {
        defaultMessage: 'Enables the OneChat chat UI.'
      }),
      name: _i18n.i18n.translate('xpack.onechat.uiSettings.chatUI.name', {
        defaultMessage: 'OneChat Chat UI'
      }),
      schema: _configSchema.schema.boolean(),
      value: false,
      readonly: true,
      readonlyMode: 'ui'
    },
    [_constants.ONECHAT_TOOLS_UI_SETTING_ID]: {
      description: _i18n.i18n.translate('xpack.onechat.uiSettings.toolsPage.description', {
        defaultMessage: 'Enables the OneChat tools page.'
      }),
      name: _i18n.i18n.translate('xpack.onechat.uiSettings.toolsPage.name', {
        defaultMessage: 'OneChat Tools Page'
      }),
      schema: _configSchema.schema.boolean(),
      value: false,
      readonly: true,
      readonlyMode: 'ui'
    }
  });
};
exports.registerUISettings = registerUISettings;