"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBuiltinToolRegistry = exports.BuiltinToolRegistryImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createBuiltinToolRegistry = () => {
  return new BuiltinToolRegistryImpl();
};
exports.createBuiltinToolRegistry = createBuiltinToolRegistry;
class BuiltinToolRegistryImpl {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _onechatCommon.builtinToolProviderId);
    (0, _defineProperty2.default)(this, "tools", new Map());
  }
  register(tool) {
    if (this.tools.has(tool.id)) {
      throw new Error(`Tool with id ${tool.id} already registered`);
    }
    this.tools.set(tool.id, tool);
  }
  async has(options) {
    const {
      toolId
    } = options;
    return this.tools.has(toolId);
  }
  async get(options) {
    const {
      toolId
    } = options;
    if (this.tools.has(toolId)) {
      return this.tools.get(toolId);
    }
    throw _onechatCommon.OnechatErrorUtils.createToolNotFoundError({
      toolId: (0, _onechatCommon.toSerializedToolIdentifier)(toolId)
    });
  }
  async list(options) {
    return [...this.tools.values()];
  }
}
exports.BuiltinToolRegistryImpl = BuiltinToolRegistryImpl;