"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createHandler = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _run_agent = require("./run_agent");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Create the handler function for the default onechat agent.
 */
const createHandler = ({
  agentId
}) => {
  return async ({
    agentParams: {
      nextInput,
      conversation = [],
      agentMode = _onechatCommon.AgentMode.normal
    },
    runId
  }, context) => {
    const {
      round
    } = await (0, _run_agent.runAgent)({
      mode: agentMode,
      nextInput,
      conversation,
      runId,
      tools: context.toolProvider
    }, context);
    return {
      result: {
        round
      }
    };
  };
};
exports.createHandler = createHandler;