"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUsageCollector = registerUsageCollector;
var _service = require("../service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerUsageCollector(usageCollection, core) {
  if (!usageCollection) {
    return;
  }
  const usageCollector = usageCollection.makeUsageCollector({
    type: 'observability_ai_assistant',
    isReady: () => true,
    schema: {
      knowledge_base: {
        users_with_global_entries: {
          type: 'long',
          _meta: {
            description: 'Number of users with global knowledge base entries'
          }
        },
        users_with_global_entries_user_created: {
          type: 'long',
          _meta: {
            description: 'Number of users with global knowledge base entries created by user'
          }
        },
        users_with_global_entries_assistant_created: {
          type: 'long',
          _meta: {
            description: 'Number of users with global knowledge base entries created by assistant'
          }
        },
        users_with_private_entries: {
          type: 'long',
          _meta: {
            description: 'Number of users with private knowledge base entries'
          }
        },
        users_with_private_entries_user_created: {
          type: 'long',
          _meta: {
            description: 'Number of users with private knowledge base entries created by user'
          }
        },
        users_with_private_entries_assistant_created: {
          type: 'long',
          _meta: {
            description: 'Number of users with private knowledge base entries created by assistant'
          }
        },
        users_with_user_instructions: {
          type: 'long',
          _meta: {
            description: 'Number of users who have configured custom user instructions'
          }
        }
      },
      conversations: {
        users_with_archived_conversations: {
          type: 'long',
          _meta: {
            description: 'Number of users with archived conversations'
          }
        },
        users_with_private_conversations: {
          type: 'long',
          _meta: {
            description: 'Number of users with private conversations'
          }
        },
        users_with_shared_conversations: {
          type: 'long',
          _meta: {
            description: 'Number of users with shared conversations'
          }
        }
      }
    },
    fetch: async () => {
      var _kbResponse$aggregati, _kbResponse$aggregati2, _kbResponse$aggregati3, _kbResponse$aggregati4, _kbResponse$aggregati5, _kbResponse$aggregati6, _kbResponse$aggregati7, _kbResponse$aggregati8, _kbResponse$aggregati9, _kbResponse$aggregati10, _kbResponse$aggregati11, _kbResponse$aggregati12, _kbResponse$aggregati13, _kbResponse$aggregati14, _kbResponse$aggregati15, _kbResponse$aggregati16, _kbResponse$aggregati17, _kbResponse$aggregati18, _kbResponse$aggregati19, _kbResponse$aggregati20, _kbResponse$aggregati21, _conversationsRespons, _conversationsRespons2, _conversationsRespons3, _conversationsRespons4, _conversationsRespons5, _conversationsRespons6, _conversationsRespons7, _conversationsRespons8, _conversationsRespons9;
      const [coreStart] = await core.getStartServices();
      const esClient = coreStart.elasticsearch.client.asInternalUser;
      const kbIndex = _service.resourceNames.indexPatterns.kb;
      const conversationsIndex = _service.resourceNames.indexPatterns.conversations;
      const kbResponse = await esClient.search({
        index: kbIndex,
        size: 0,
        query: {
          bool: {
            filter: [{
              exists: {
                field: 'user.id'
              }
            }]
          }
        },
        aggs: {
          global_entries: {
            filter: {
              term: {
                public: true
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          global_entries_user_created: {
            filter: {
              bool: {
                filter: [{
                  term: {
                    public: true
                  }
                }, {
                  term: {
                    role: 'user_entry'
                  }
                }]
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          global_entries_assistant_created: {
            filter: {
              bool: {
                filter: [{
                  term: {
                    public: true
                  }
                }, {
                  term: {
                    role: 'assistant_summarization'
                  }
                }]
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          private_entries: {
            filter: {
              bool: {
                filter: [{
                  term: {
                    public: false
                  }
                }],
                must_not: [{
                  term: {
                    type: 'user_instruction'
                  }
                }]
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          private_entries_user_created: {
            filter: {
              bool: {
                filter: [{
                  term: {
                    public: false
                  }
                }, {
                  term: {
                    role: 'user_entry'
                  }
                }],
                must_not: [{
                  term: {
                    type: 'user_instruction'
                  }
                }]
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          private_entries_assistant_created: {
            filter: {
              bool: {
                filter: [{
                  term: {
                    public: false
                  }
                }, {
                  term: {
                    role: 'assistant_summarization'
                  }
                }]
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          user_instructions: {
            filter: {
              term: {
                type: 'user_instruction'
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          }
        }
      });
      const conversationsResponse = await esClient.search({
        index: conversationsIndex,
        size: 0,
        query: {
          bool: {
            filter: [{
              exists: {
                field: 'user.id'
              }
            }]
          }
        },
        aggs: {
          archived: {
            filter: {
              term: {
                archived: true
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          private: {
            filter: {
              term: {
                public: false
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          },
          shared: {
            filter: {
              term: {
                public: true
              }
            },
            aggs: {
              unique_users: {
                cardinality: {
                  field: 'user.id'
                }
              }
            }
          }
        }
      });
      return {
        knowledge_base: {
          users_with_global_entries: (_kbResponse$aggregati = kbResponse.aggregations) === null || _kbResponse$aggregati === void 0 ? void 0 : (_kbResponse$aggregati2 = _kbResponse$aggregati.global_entries) === null || _kbResponse$aggregati2 === void 0 ? void 0 : (_kbResponse$aggregati3 = _kbResponse$aggregati2.unique_users) === null || _kbResponse$aggregati3 === void 0 ? void 0 : _kbResponse$aggregati3.value,
          users_with_global_entries_user_created: (_kbResponse$aggregati4 = kbResponse.aggregations) === null || _kbResponse$aggregati4 === void 0 ? void 0 : (_kbResponse$aggregati5 = _kbResponse$aggregati4.global_entries_user_created) === null || _kbResponse$aggregati5 === void 0 ? void 0 : (_kbResponse$aggregati6 = _kbResponse$aggregati5.unique_users) === null || _kbResponse$aggregati6 === void 0 ? void 0 : _kbResponse$aggregati6.value,
          users_with_global_entries_assistant_created: (_kbResponse$aggregati7 = kbResponse.aggregations) === null || _kbResponse$aggregati7 === void 0 ? void 0 : (_kbResponse$aggregati8 = _kbResponse$aggregati7.global_entries_assistant_created) === null || _kbResponse$aggregati8 === void 0 ? void 0 : (_kbResponse$aggregati9 = _kbResponse$aggregati8.unique_users) === null || _kbResponse$aggregati9 === void 0 ? void 0 : _kbResponse$aggregati9.value,
          users_with_private_entries: (_kbResponse$aggregati10 = kbResponse.aggregations) === null || _kbResponse$aggregati10 === void 0 ? void 0 : (_kbResponse$aggregati11 = _kbResponse$aggregati10.private_entries) === null || _kbResponse$aggregati11 === void 0 ? void 0 : (_kbResponse$aggregati12 = _kbResponse$aggregati11.unique_users) === null || _kbResponse$aggregati12 === void 0 ? void 0 : _kbResponse$aggregati12.value,
          users_with_private_entries_user_created: (_kbResponse$aggregati13 = kbResponse.aggregations) === null || _kbResponse$aggregati13 === void 0 ? void 0 : (_kbResponse$aggregati14 = _kbResponse$aggregati13.private_entries_user_created) === null || _kbResponse$aggregati14 === void 0 ? void 0 : (_kbResponse$aggregati15 = _kbResponse$aggregati14.unique_users) === null || _kbResponse$aggregati15 === void 0 ? void 0 : _kbResponse$aggregati15.value,
          users_with_private_entries_assistant_created: (_kbResponse$aggregati16 = kbResponse.aggregations) === null || _kbResponse$aggregati16 === void 0 ? void 0 : (_kbResponse$aggregati17 = _kbResponse$aggregati16.private_entries_assistant_created) === null || _kbResponse$aggregati17 === void 0 ? void 0 : (_kbResponse$aggregati18 = _kbResponse$aggregati17.unique_users) === null || _kbResponse$aggregati18 === void 0 ? void 0 : _kbResponse$aggregati18.value,
          users_with_user_instructions: (_kbResponse$aggregati19 = kbResponse.aggregations) === null || _kbResponse$aggregati19 === void 0 ? void 0 : (_kbResponse$aggregati20 = _kbResponse$aggregati19.user_instructions) === null || _kbResponse$aggregati20 === void 0 ? void 0 : (_kbResponse$aggregati21 = _kbResponse$aggregati20.unique_users) === null || _kbResponse$aggregati21 === void 0 ? void 0 : _kbResponse$aggregati21.value
        },
        conversations: {
          users_with_archived_conversations: (_conversationsRespons = conversationsResponse.aggregations) === null || _conversationsRespons === void 0 ? void 0 : (_conversationsRespons2 = _conversationsRespons.archived) === null || _conversationsRespons2 === void 0 ? void 0 : (_conversationsRespons3 = _conversationsRespons2.unique_users) === null || _conversationsRespons3 === void 0 ? void 0 : _conversationsRespons3.value,
          users_with_private_conversations: (_conversationsRespons4 = conversationsResponse.aggregations) === null || _conversationsRespons4 === void 0 ? void 0 : (_conversationsRespons5 = _conversationsRespons4.private) === null || _conversationsRespons5 === void 0 ? void 0 : (_conversationsRespons6 = _conversationsRespons5.unique_users) === null || _conversationsRespons6 === void 0 ? void 0 : _conversationsRespons6.value,
          users_with_shared_conversations: (_conversationsRespons7 = conversationsResponse.aggregations) === null || _conversationsRespons7 === void 0 ? void 0 : (_conversationsRespons8 = _conversationsRespons7.shared) === null || _conversationsRespons8 === void 0 ? void 0 : (_conversationsRespons9 = _conversationsRespons8.unique_users) === null || _conversationsRespons9 === void 0 ? void 0 : _conversationsRespons9.value
        }
      };
    }
  });
  usageCollection.registerCollector(usageCollector);
}