"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BeatsPanel = BeatsPanel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _format_number = require("../../../lib/format_number");
var _eui = require("@elastic/eui");
var _helpers = require("./helpers");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _tooltip = require("../../setup_mode/tooltip");
var _constants = require("../../../../common/constants");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _setup_mode = require("../../../lib/setup_mode");
var _enums = require("../../../../common/enums");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BeatsPanel(props) {
  const {
    setupMode
  } = props;
  const beatsTotal = (0, _lodash.get)(props, 'beats.total') || 0;
  // Do not show if we are not in setup mode
  if (beatsTotal === 0 && !setupMode.enabled) {
    return null;
  }
  const setupModeData = (0, _lodash.get)(setupMode.data, 'beats');
  const setupModeMetricbeatMigrationTooltip = (0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration) ? /*#__PURE__*/_react.default.createElement(_tooltip.SetupModeTooltip, {
    setupModeData: setupModeData,
    productName: _constants.BEATS_SYSTEM_ID,
    badgeClickLink: (0, _get_safe_for_external_link.getSafeForExternalLink)('#/beats/beats')
  }) : null;
  const beatTypes = (0, _lodash.get)(props, 'beats.types', []).map((beat, index) => {
    return [/*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      key: `beat-types-type-${index}`,
      "data-test-subj": "beatTypeCount",
      "data-test-beat-type-count": beat.type + ':' + beat.count
    }, beat.type), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      key: `beat-types-count-${index}`
    }, beat.count)];
  });
  return /*#__PURE__*/_react.default.createElement(_helpers.ClusterItemContainer, (0, _extends2.default)({}, props, {
    url: "beats",
    title: _i18n.i18n.translate('xpack.monitoring.cluster.overview.beatsPanel.beatsTitle', {
      defaultMessage: 'Beats'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_helpers.DisabledIfNoDataAndInSetupModeLink, {
    setupModeEnabled: setupMode.enabled,
    setupModeData: setupModeData,
    href: (0, _get_safe_for_external_link.getSafeForExternalLink)('#/beats'),
    "aria-label": _i18n.i18n.translate('xpack.monitoring.cluster.overview.beatsPanel.overviewLinkAriaLabel', {
      defaultMessage: 'Beats Overview'
    }),
    "data-test-subj": "beatsOverview"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.beatsPanel.overviewLinkLabel",
    defaultMessage: "Overview"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.beatsPanel.totalEventsLabel",
    defaultMessage: "Total Events"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "beatsTotalEvents"
  }, (0, _format_number.formatMetric)(props.totalEvents, '0.[0]a')), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.beatsPanel.bytesSentLabel",
    defaultMessage: "Bytes Sent"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "beatsBytesSent"
  }, (0, _format_number.formatMetric)(props.bytesSent, 'byte'))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: (0, _get_safe_for_external_link.getSafeForExternalLink)('#/beats/beats'),
    "aria-label": _i18n.i18n.translate('xpack.monitoring.cluster.overview.beatsPanel.instancesTotalLinkAriaLabel', {
      defaultMessage: 'Beats Instances: {beatsTotal}',
      values: {
        beatsTotal
      }
    }),
    "data-test-subj": "beatsListing"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.beatsPanel.beatsTotalLinkLabel",
    defaultMessage: "Beats: {beatsTotal}",
    values: {
      beatsTotal: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "beatsTotal"
      }, beatsTotal)
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, setupModeMetricbeatMigrationTooltip))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column"
  }, beatTypes)))));
}