"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGeneralInputComponent = exports.TextInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _inference_base = require("./inference_base");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TextInput = ({
  placeholder,
  inferrer
}) => {
  const [inputText, setInputText] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    inferrer.setInputText([inputText]);
  }, [inputText, inferrer]);
  const runningState = (0, _useObservable.default)(inferrer.getRunningState$(), inferrer.getRunningState());
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.generalTextInput.inputTitle', {
      defaultMessage: 'Input text'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.generalTextInput.inputText', {
      defaultMessage: 'Input text'
    }),
    value: inputText,
    disabled: runningState === _inference_base.RUNNING_STATE.RUNNING,
    fullWidth: true,
    onChange: e => {
      setInputText(e.target.value);
    },
    "data-test-subj": `mlTestModelInputText`
  }));
};
exports.TextInput = TextInput;
const getGeneralInputComponent = (inferrer, placeholder) => /*#__PURE__*/_react.default.createElement(TextInput, {
  placeholder: placeholder,
  inferrer: inferrer
});
exports.getGeneralInputComponent = getGeneralInputComponent;