"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditQueryDelay = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../contexts/kibana");
var _toast_notification_service = require("../../../../services/toast_notification_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tooltipContent = _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.editQueryDelay.tooltipContent', {
  defaultMessage: 'To edit the query delay, you must have permission to edit the datafeed and the datafeed cannot be running.'
});
const EditQueryDelay = ({
  datafeedId,
  queryDelay,
  isEnabled
}) => {
  const [currentQueryDelay, setCurrentQueryDelay] = (0, _react.useState)(queryDelay);
  const [newQueryDelay, setNewQueryDelay] = (0, _react.useState)();
  const [isEditing, setIsEditing] = (0, _react.useState)(false);
  const {
    updateDatafeed
  } = (0, _kibana.useMlApi)();
  const {
    displaySuccessToast,
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const updateQueryDelay = (0, _react.useCallback)(async () => {
    try {
      await updateDatafeed({
        datafeedId,
        datafeedConfig: {
          query_delay: newQueryDelay
        }
      });
      setCurrentQueryDelay(newQueryDelay);
      displaySuccessToast(_i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.editQueryDelay.changesSavedNotificationMessage', {
        defaultMessage: 'Changes to query delay for {datafeedId} saved',
        values: {
          datafeedId
        }
      }));
    } catch (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.editQueryDelay.changesNotSavedNotificationMessage', {
        defaultMessage: 'Could not save changes to query delay for {datafeedId}',
        values: {
          datafeedId
        }
      }));
    }
    setIsEditing(false);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [datafeedId, newQueryDelay]);
  const editButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    size: "xs",
    isDisabled: isEnabled === false,
    onClick: () => {
      setIsEditing(true);
    },
    iconType: "pencil"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.datafeedChart.queryDelayLinkLabel",
    defaultMessage: "Query delay: {queryDelay}",
    values: {
      queryDelay: newQueryDelay || queryDelay
    }
  }));
  const editButtonWithTooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent
  }, editButton);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEditing === false ? isEnabled === false ? editButtonWithTooltip : editButton : null, isEditing === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.datafeedChart.queryDelayLabel",
      defaultMessage: "Query delay"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: newQueryDelay || queryDelay
    // @ts-expect-error queryDelay is of type estypes.Duration = string | -1 | 0
    ,
    placeholder: queryDelay,
    onChange: e => {
      setNewQueryDelay(e.target.value);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: newQueryDelay === currentQueryDelay,
    color: "primary",
    size: "xs",
    onClick: updateQueryDelay
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.datafeedChart.applyQueryDelayLabel",
    defaultMessage: "Apply"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    size: "xs",
    onClick: () => setIsEditing(false)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.datafeedChart.cancelQueryDelayUpdateLabel",
    defaultMessage: "Cancel"
  }))))))) : null);
};
exports.EditQueryDelay = EditQueryDelay;