"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScalingDocumenationPopover = ScalingDocumenationPopover;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_services = require("../../../../kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ScalingDocumenationPopover(props) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "scalingHelpPopover",
    anchorPosition: "leftCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
      },
      iconType: "documentation",
      "aria-label": "Scaling documentation"
    }),
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(false);
    },
    repositionOnScroll: true,
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.title",
    defaultMessage: "Scaling"
  })), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    style: {
      maxWidth: '36em'
    }
  }, /*#__PURE__*/_react.default.createElement("dl", null, /*#__PURE__*/_react.default.createElement("dt", null, props.mvtOptionLabel, " (Default)"), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.mvtDetails",
    defaultMessage: "Vector tiles partition your map into tiles, with each tile displaying features from the first {maxResultWindow} documents. Results exceeding {maxResultWindow} are not displayed in a tile. A bounding box indicates the area where data is incomplete.",
    values: {
      maxResultWindow: props.maxResultWindow
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.mvtUseCase",
    defaultMessage: "Use this option to display large data sets with the fastest loading times."
  }))), /*#__PURE__*/_react.default.createElement("dt", null, props.clustersOptionLabel), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.clustersDetails",
    defaultMessage: "Display clusters when results exceed {maxResultWindow} documents. Display documents when results are less then {maxResultWindow}.",
    values: {
      maxResultWindow: props.maxResultWindow
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.clustersUseCase",
    defaultMessage: "Use this option to display large data sets. "
  }), /*#__PURE__*/_react.default.createElement("i", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.doesNotSupportJoins",
    defaultMessage: "Does not support joins."
  })))), /*#__PURE__*/_react.default.createElement("dt", null, props.limitOptionLabel), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.limitDetails",
    defaultMessage: "Display features from the first {maxResultWindow} documents.",
    values: {
      maxResultWindow: props.maxResultWindow
    }
  })), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.limitUseCases",
    defaultMessage: "Use this option when you can not use vector tiles for the following reasons:"
  }), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.limitUseCase.formatLabels",
    defaultMessage: "Formatted labels"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.limitUseCase.multipleJoins",
    defaultMessage: "Spatial joins"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.limitUseCase.spatialJoins",
    defaultMessage: "Multiple term joins"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.limitUseCase.joinFieldsWithLayoutStyles",
    defaultMessage: "Data driven styling from join metrics with 'Label', 'Label size', icon 'Symbol size', and 'Symbol orientation' style properties"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.limitUseCase.scriptedFields",
    defaultMessage: "Data driven styling from scripted fields"
  }))))), /*#__PURE__*/_react.default.createElement("p", {
    style: {
      fontStyle: 'italic'
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.scalingDocs.maxResultWindow",
    defaultMessage: "{maxResultWindow} constraint provided by {link} index setting.",
    values: {
      maxResultWindow: props.maxResultWindow,
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: (0, _kibana_services.getDocLinks)().links.elasticsearch.dynamicIndexSettings,
        target: "_blank",
        external: true
      }, "max_result_window")
    }
  })))));
}