"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _sections = require("./sections");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../common/constants");
var _shared_imports = require("../shared_imports");
var _eui = require("@elastic/eui");
var _locator = require("../locator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const App = ({
  hasPermission,
  permissionsLoading,
  permissionsError,
  telemetry,
  loadPermissions,
  executionContext
}) => {
  (0, _shared_imports.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'licenseManagement'
  });
  (0, _react.useEffect)(() => {
    loadPermissions();
  }, [loadPermissions]);
  if (permissionsLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.app.loadingPermissionsDescription",
      defaultMessage: "Checking permissions\u2026"
    })));
  }
  if (permissionsError) {
    var _permissionsError$dat;
    const error = permissionsError === null || permissionsError === void 0 ? void 0 : (_permissionsError$dat = permissionsError.data) === null || _permissionsError$dat === void 0 ? void 0 : _permissionsError$dat.message;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.app.checkingPermissionsErrorMessage",
        defaultMessage: "Error checking permissions"
      })),
      body: error ? /*#__PURE__*/_react.default.createElement("p", null, error) : null
    }));
  }
  if (!hasPermission) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "subdued",
      iconType: "securityApp",
      title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.app.deniedPermissionTitle",
        defaultMessage: "Cluster privileges required"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.app.deniedPermissionDescription",
        defaultMessage: "To use License Management, you must have {permissionType} privileges.",
        values: {
          permissionType: /*#__PURE__*/_react.default.createElement("strong", null, _constants.APP_PERMISSION)
        }
      }))
    }));
  }
  const withTelemetry = Component => props => /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
    telemetry: telemetry
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/${_locator.UPLOAD_LICENSE_ROUTE}`,
    component: withTelemetry(_sections.UploadLicense)
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ['/'],
    component: withTelemetry(_sections.LicenseDashboard)
  })));
};
exports.App = App;