"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./app.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _full_screen_bg_css = require("@kbn/css-utils/public/full_screen_bg_css");
var _i18nReact = require("@kbn/i18n-react");
var _cluster_address_form = require("./cluster_address_form");
var _cluster_configuration_form = require("./cluster_configuration_form");
var _enrollment_token_form = require("./enrollment_token_form");
var _progress_indicator = require("./progress_indicator");
var _use_kibana = require("./use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const App = ({
  onSuccess
}) => {
  const [page, setPage] = (0, _react.useState)('token');
  const [cluster, setCluster] = (0, _react.useState)();
  const {
    http
  } = (0, _use_kibana.useKibana)();
  const state = (0, _useAsync.default)(() => http.get('/internal/interactive_setup/status'), [http]);
  const kbnFullScreenBgCss = (0, _full_screen_bg_css.useKbnFullScreenBgCss)();
  if (state.loading) {
    return null;
  }
  if (!state.value || state.value.connectionStatus === 'configured' || !state.value.isSetupOnHold) {
    return /*#__PURE__*/_react.default.createElement("pre", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "interactiveSetup.app.notReady",
      defaultMessage: "Kibana server is not ready yet."
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: kbnFullScreenBgCss
  }, /*#__PURE__*/_react.default.createElement("header", {
    className: "interactiveSetup__header eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "interactiveSetup__logo"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoElastic",
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.app.pageTitle",
    defaultMessage: "Configure Elastic to get started"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "interactiveSetup__content"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement("div", {
    hidden: page !== 'token'
  }, /*#__PURE__*/_react.default.createElement(_enrollment_token_form.EnrollmentTokenForm, {
    onCancel: () => setPage('manual'),
    onSuccess: () => setPage('success')
  })), /*#__PURE__*/_react.default.createElement("div", {
    hidden: page !== 'manual'
  }, cluster ? /*#__PURE__*/_react.default.createElement(_cluster_configuration_form.ClusterConfigurationForm, (0, _extends2.default)({
    onCancel: () => setCluster(undefined),
    onSuccess: () => setPage('success')
  }, cluster)) : /*#__PURE__*/_react.default.createElement(_cluster_address_form.ClusterAddressForm, {
    onCancel: () => setPage('token'),
    onSuccess: (result, values) => setCluster({
      host: values.host,
      authRequired: result.authRequired,
      certificateChain: result.certificateChain
    })
  })), page === 'success' && /*#__PURE__*/_react.default.createElement(_progress_indicator.ProgressIndicator, {
    onSuccess: onSuccess
  }))));
};
exports.App = App;