"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _app_context = require("../../../../../app_context");
var _overview_card = require("./overview_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const healthToBadgeMapping = {
  green: {
    color: 'success',
    label: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.health.greenLabel', {
      defaultMessage: 'Healthy'
    })
  },
  yellow: {
    color: 'warning',
    label: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.health.yellowLabel', {
      defaultMessage: 'Warning'
    })
  },
  red: {
    color: 'danger',
    label: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.health.redLabel', {
      defaultMessage: 'Critical'
    })
  }
};
const StatusDetails = ({
  documents,
  documentsDeleted,
  status,
  health
}) => {
  const largeFontSize = (0, _eui.useEuiFontSize)('l').fontSize;
  const {
    config
  } = (0, _app_context.useAppContext)();
  if (!config.enableIndexStats || !health) {
    return null;
  }
  const badgeConfig = healthToBadgeMapping[health.toLowerCase()];
  const healthBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: badgeConfig.color
  }, badgeConfig.label);
  return /*#__PURE__*/_react.default.createElement(_overview_card.OverviewCard, {
    "data-test-subj": "indexDetailsStatus",
    title: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.status.cardTitle', {
      defaultMessage: 'Status'
    }),
    content: {
      left: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: status === 'close' ? 'danger' : 'success',
        css: (0, _react2.css)`
              font-size: ${largeFontSize};
            `
      }, status === 'close' ? _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.status.closedLabel', {
        defaultMessage: 'Closed'
      }) : _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.status.openLabel', {
        defaultMessage: 'Open'
      })),
      right: /*#__PURE__*/_react.default.createElement("div", {
        css: (0, _react2.css)`
              max-width: 100px;
            `
      }, healthBadge)
    },
    footer: {
      left: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "documents",
        color: "subdued"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.status.documentsLabel', {
        defaultMessage: '{documents, plural, one {# Document} other {# Documents}} / {documentsDeleted} Deleted',
        values: {
          documents,
          documentsDeleted
        }
      }))))
    }
  });
};
exports.StatusDetails = StatusDetails;