"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditFieldFormRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _shared_imports = require("../../../../shared_imports");
var _lib = require("../../../../lib");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditFieldFormRow = exports.EditFieldFormRow = /*#__PURE__*/_react.default.memo(({
  title,
  description,
  docLink,
  defaultToggleValue,
  formFieldPath,
  children,
  withToggle = true,
  configPath,
  'data-test-subj': dataTestSubj
}) => {
  const form = (0, _shared_imports.useFormContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = {
    formRow: (0, _react2.css)`
        margin-bottom: ${euiTheme.size.xl};

        &:last-child {
          margin-bottom: 0;
        }
      `,
    description: (0, _react2.css)`
        padding-top: ${euiTheme.size.xs};
      `
  };
  const initialVisibleState = withToggle === false ? true : defaultToggleValue !== undefined ? defaultToggleValue : formFieldPath !== undefined ? (0, _lib.getFieldConfig)(configPath ? configPath : formFieldPath).defaultValue : false;
  const [isContentVisible, setIsContentVisible] = (0, _react.useState)(initialVisibleState);
  const isChildrenFunction = typeof children === 'function';
  const onToggle = () => {
    if (isContentVisible === true) {
      /**
       * We are hiding the children (and thus removing any form field from the DOM).
       * We need to reset the form to re-enable a possible disabled "save" button (from a previous validation error).
       */
      form.reset({
        resetValues: false
      });
    }
    setIsContentVisible(!isContentVisible);
  };
  const renderToggleInput = () => formFieldPath === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: title,
    checked: isContentVisible,
    onChange: onToggle,
    "data-test-subj": "formRowToggle",
    showLabel: false
  }) : /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: formFieldPath,
    config: {
      ...(0, _lib.getFieldConfig)(configPath ? configPath : formFieldPath),
      defaultValue: initialVisibleState
    }
  }, field => {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.ToggleField, {
      field: field,
      "data-test-subj": "abc",
      euiFieldProps: {
        label: title,
        showLabel: false,
        'data-test-subj': 'formRowToggle'
      }
    });
  });
  const renderContent = () => {
    const toggle = withToggle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, renderToggleInput());
    const controlsTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, title));
    const controlsDescription = description && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      css: styles.description
    }, description);
    const controlsHeader = (controlsTitle || controlsDescription) && /*#__PURE__*/_react.default.createElement("div", {
      style: {
        paddingLeft: withToggle === false ? '0' : undefined
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, controlsTitle), docLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: docLink.text,
      disableScreenReaderOutput: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      href: docLink.href,
      target: "_blank",
      iconType: "question",
      "aria-label": docLink.text
    }))) : null), controlsDescription);
    const controls = (isContentVisible && children !== undefined || isChildrenFunction) && /*#__PURE__*/_react.default.createElement("div", {
      style: {
        paddingLeft: withToggle === false ? '0' : undefined
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), isChildrenFunction ? children(isContentVisible) : children);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      css: styles.formRow,
      "data-test-subj": dataTestSubj
    }, toggle, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, controlsHeader, controls)));
  };
  return formFieldPath ? /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: formFieldPath
  }, formData => {
    setIsContentVisible((0, _lodash.get)(formData, formFieldPath));
    return renderContent();
  }) : renderContent();
});