"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithGuidedOnboardingTour = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTourConfig = (packageKey, tourType) => {
  if (packageKey.startsWith('endpoint') && tourType === 'addIntegrationButton') {
    return {
      title: _i18n.i18n.translate('xpack.fleet.guidedOnboardingTour.endpointButton.title', {
        defaultMessage: 'Add Elastic Defend'
      }),
      description: _i18n.i18n.translate('xpack.fleet.guidedOnboardingTour.endpointButton.description', {
        defaultMessage: `In this workflow, we'll be using Elastic Defend only to collect data for SIEM. Installing this will not conflict with existing endpoint security products.`
      })
    };
  }
  if (packageKey.startsWith('endpoint') && tourType === 'integrationCard') {
    return {
      title: _i18n.i18n.translate('xpack.fleet.guidedOnboardingTour.endpointCard.title', {
        defaultMessage: 'Select Elastic Defend'
      }),
      description: _i18n.i18n.translate('xpack.fleet.guidedOnboardingTour.endpointCard.description', {
        defaultMessage: 'The best way to get data quickly into your SIEM.'
      })
    };
  }
  if (packageKey.startsWith('kubernetes') && tourType === 'addIntegrationButton') {
    return {
      title: _i18n.i18n.translate('xpack.fleet.guidedOnboardingTour.kubernetesButton.tourTitle', {
        defaultMessage: 'Add Kubernetes'
      }),
      description: _i18n.i18n.translate('xpack.fleet.guidedOnboardingTour.kubernetesButton.tourDescription', {
        defaultMessage: 'In just a few steps, add your data with our recommended defaults. You can change this later.'
      })
    };
  }
  if (packageKey.startsWith('kubernetes') && tourType === 'agentModalButton') {
    return {
      title: _i18n.i18n.translate('xpack.fleet.guidedOnboardingTour.agentModalButton.tourTitle', {
        defaultMessage: 'Add Elastic Agent'
      }),
      description: _i18n.i18n.translate('xpack.fleet.guidedOnboardingTour.agentModalButton.tourDescription', {
        defaultMessage: 'In order to proceed with your setup, add Elastic Agent to your hosts now.'
      })
    };
  }
  return null;
};
const WithGuidedOnboardingTour = ({
  packageKey,
  isTourVisible,
  tourType,
  children,
  tourPosition,
  tourOffset
}) => {
  const [isGuidedOnboardingTourOpen, setIsGuidedOnboardingTourOpen] = (0, _react.useState)(isTourVisible);
  (0, _react.useEffect)(() => {
    setIsGuidedOnboardingTourOpen(isTourVisible);
  }, [isTourVisible]);
  const config = getTourConfig(packageKey, tourType);
  return config ? /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, config.description),
    isStepOpen: isGuidedOnboardingTourOpen,
    maxWidth: 350,
    onFinish: () => setIsGuidedOnboardingTourOpen(false),
    step: 1,
    stepsTotal: 1,
    offset: tourOffset,
    title: config.title,
    anchorPosition: tourPosition ? tourPosition : 'rightUp',
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => setIsGuidedOnboardingTourOpen(false),
      size: "xs",
      color: "text",
      flush: "right"
    }, _i18n.i18n.translate('xpack.fleet.guidedOnboardingTour.nextButtonLabel', {
      defaultMessage: 'Continue'
    })),
    isOpen: isGuidedOnboardingTourOpen
    // Close the tour when the user clicks outside of the tour. This is a workaround for
    // popover remaining open when the user changes the category of the integration list
    ,
    closePopover: () => setIsGuidedOnboardingTourOpen(false)
  }, children) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
exports.WithGuidedOnboardingTour = WithGuidedOnboardingTour;