"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _constants = require("../../../../../constants");
var _side_bar_column = require("../../../components/side_bar_column");
var _components = require("../components");
var _hooks2 = require("../hooks");
var _install_button = require("./install_button");
var _reinstall_button = require("./reinstall_button");
var _update_button = require("./update_button");
var _uninstall_button = require("./uninstall_button");
var _changelog_modal = require("./changelog_modal");
var _update_available_callout = require("./update_available_callout");
var _breaking_changes_flyout = require("./breaking_changes_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SettingsTitleCell = _styledComponents.default.td`
  padding-right: ${props => props.theme.eui.euiSizeXL};
  padding-bottom: ${props => props.theme.eui.euiSizeM};
`;
const NoteLabel = () => /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.integrations.settings.packageUninstallNoteDescription.packageUninstallNoteLabel",
  defaultMessage: "Note:"
}));
const LatestVersionLink = ({
  name,
  version
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const settingsPath = getHref('integration_details_settings', {
    pkgkey: `${name}-${version}`
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: settingsPath
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageLatestVersionLink",
    defaultMessage: "latest version"
  }));
};
const SettingsPage = exports.SettingsPage = /*#__PURE__*/(0, _react.memo)(({
  packageInfo,
  packageMetadata,
  startServices,
  isCustomPackage
}) => {
  var _packageInfo$installa;
  const authz = (0, _hooks.useAuthz)();
  const {
    name,
    title,
    latestVersion,
    version,
    keepPoliciesUpToDate
  } = packageInfo;
  const [isUpgradingPackagePolicies, setIsUpgradingPackagePolicies] = (0, _react.useState)(false);
  const [isChangelogModalOpen, setIsChangelogModalOpen] = (0, _react.useState)(false);
  const [isBreakingChangesUnderstood, setIsBreakingChangesUnderstood] = (0, _react.useState)(false);
  const [isBreakingChangesFlyoutOpen, setIsBreakingChangesFlyoutOpen] = (0, _react.useState)(false);
  const toggleChangelogModal = (0, _react.useCallback)(() => {
    setIsChangelogModalOpen(!isChangelogModalOpen);
  }, [isChangelogModalOpen]);
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const {
    data: packagePoliciesData
  } = (0, _hooks.useGetPackagePoliciesQuery)({
    perPage: _constants.SO_SEARCH_LIMIT,
    page: 1,
    kuery: `${_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${name}`
  });
  const {
    changelog,
    breakingChanges,
    isLoading: isChangelogLoading,
    error: changelogError
  } = (0, _hooks2.useChangelog)(name, latestVersion, version);
  const packagePolicyIds = (0, _react.useMemo)(() => packagePoliciesData === null || packagePoliciesData === void 0 ? void 0 : packagePoliciesData.items.map(({
    id
  }) => id), [packagePoliciesData]);
  const agentPolicyIds = (0, _react.useMemo)(() => {
    var _packagePoliciesData$;
    return (_packagePoliciesData$ = packagePoliciesData === null || packagePoliciesData === void 0 ? void 0 : packagePoliciesData.items.flatMap(packagePolicy => packagePolicy.policy_ids)) !== null && _packagePoliciesData$ !== void 0 ? _packagePoliciesData$ : [];
  }, [packagePoliciesData]);
  const {
    data: dryRunData
  } = (0, _hooks.useUpgradePackagePolicyDryRunQuery)(packagePolicyIds !== null && packagePolicyIds !== void 0 ? packagePolicyIds : [], latestVersion, {
    enabled: packagePolicyIds && packagePolicyIds.length > 0
  });
  const updatePackageMutation = (0, _hooks.useUpdatePackageMutation)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const shouldShowKeepPoliciesUpToDateSwitch = (0, _react.useMemo)(() => {
    return _constants.KEEP_POLICIES_UP_TO_DATE_PACKAGES.some(pkg => pkg.name === name);
  }, [name]);
  const isShowKeepPoliciesUpToDateSwitchDisabled = (0, _react.useMemo)(() => {
    return !authz.integrations.writePackageSettings || _constants.AUTO_UPGRADE_POLICIES_PACKAGES.some(pkg => pkg.name === name);
  }, [authz.integrations.writePackageSettings, name]);
  const [keepPoliciesUpToDateSwitchValue, setKeepPoliciesUpToDateSwitchValue] = (0, _react.useState)(keepPoliciesUpToDate !== null && keepPoliciesUpToDate !== void 0 ? keepPoliciesUpToDate : false);
  const handleKeepPoliciesUpToDateSwitchChange = (0, _react.useCallback)(() => {
    setKeepPoliciesUpToDateSwitchValue(prev => !prev);
    updatePackageMutation.mutate({
      pkgName: packageInfo.name,
      pkgVersion: packageInfo.version,
      body: {
        keepPoliciesUpToDate: !keepPoliciesUpToDateSwitchValue
      }
    }, {
      onSuccess: () => {
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.fleet.integrations.integrationSaved', {
            defaultMessage: 'Integration settings saved'
          }),
          text: !keepPoliciesUpToDateSwitchValue ? _i18n.i18n.translate('xpack.fleet.integrations.keepPoliciesUpToDateEnabledSuccess', {
            defaultMessage: 'Fleet will automatically keep integration policies up to date for {title}',
            values: {
              title
            }
          }) : _i18n.i18n.translate('xpack.fleet.integrations.keepPoliciesUpToDateDisabledSuccess', {
            defaultMessage: 'Fleet will not automatically keep integration policies up to date for {title}',
            values: {
              title
            }
          })
        });
      },
      onError: error => {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.integrations.integrationSavedError', {
            defaultMessage: 'Error saving integration settings'
          }),
          toastMessage: _i18n.i18n.translate('xpack.fleet.integrations.keepPoliciesUpToDateError', {
            defaultMessage: 'Error saving integration settings for {title}',
            values: {
              title
            }
          })
        });
      }
    });
  }, [keepPoliciesUpToDateSwitchValue, notifications.toasts, packageInfo.name, packageInfo.version, title, updatePackageMutation]);
  const {
    status: installationStatus,
    version: installedVersion
  } = getPackageInstallStatus(name);
  const updateAvailable = installedVersion && (0, _lt.default)(installedVersion, latestVersion) ? true : false;
  const isViewingOldPackage = version < latestVersion;
  // hide install/remove options if the user has version of the package is installed
  // and this package is out of date or if they do have a version installed but it's not this one
  const hideInstallOptions = installationStatus === _types.InstallStatus.notInstalled && isViewingOldPackage || installationStatus === _types.InstallStatus.installed && installedVersion !== version;
  const isUpdating = installationStatus === _types.InstallStatus.installing && installedVersion;
  (0, _react.useEffect)(() => {
    if (changelogError) {
      notifications.toasts.addError(changelogError, {
        title: _i18n.i18n.translate('xpack.fleet.epm.errorLoadingChangelog', {
          defaultMessage: 'Error loading changelog information'
        })
      });
    }
  }, [changelogError, notifications.toasts]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_side_bar_column.SideBarColumn, {
    grow: 1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageSettingsTitle",
    defaultMessage: "Settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), installedVersion !== null && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageVersionTitle",
    defaultMessage: "{title} version",
    values: {
      title
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("table", null, /*#__PURE__*/_react.default.createElement("tbody", null, /*#__PURE__*/_react.default.createElement("tr", null, /*#__PURE__*/_react.default.createElement(SettingsTitleCell, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.versionInfo.installedVersion",
    defaultMessage: "Installed version"
  })), /*#__PURE__*/_react.default.createElement("td", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "epmSettings.installedVersionTitle"
  }, /*#__PURE__*/_react.default.createElement("span", null, installedVersion)))), /*#__PURE__*/_react.default.createElement("tr", null, /*#__PURE__*/_react.default.createElement(SettingsTitleCell, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.versionInfo.latestVersion",
    defaultMessage: "Latest version"
  })), /*#__PURE__*/_react.default.createElement("td", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "epmSettings.latestVersionTitle"
  }, /*#__PURE__*/_react.default.createElement("span", null, latestVersion)))))), shouldShowKeepPoliciesUpToDateSwitch && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.KeepPoliciesUpToDateSwitch, {
    checked: keepPoliciesUpToDateSwitchValue,
    onChange: handleKeepPoliciesUpToDateSwitchChange,
    disabled: isShowKeepPoliciesUpToDateSwitchDisabled
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), (updateAvailable || isUpgradingPackagePolicies) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_update_available_callout.UpdateAvailableCallout, {
    version: latestVersion,
    toggleChangelogModal: toggleChangelogModal,
    breakingChanges: breakingChanges ? {
      changelog: breakingChanges,
      isUnderstood: isBreakingChangesUnderstood,
      toggleIsUnderstood: () => setIsBreakingChangesUnderstood(prev => !prev),
      onOpen: () => setIsBreakingChangesFlyoutOpen(true)
    } : null
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_update_button.UpdateButton, (0, _extends2.default)({}, packageInfo, {
    version: latestVersion,
    agentPolicyIds: agentPolicyIds,
    packagePolicyIds: packagePolicyIds,
    dryRunData: dryRunData,
    isUpgradingPackagePolicies: isUpgradingPackagePolicies,
    setIsUpgradingPackagePolicies: setIsUpgradingPackagePolicies,
    startServices: startServices,
    isDisabled: Boolean(breakingChanges) && !isBreakingChangesUnderstood
  }))))), !hideInstallOptions && !isUpdating && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), installationStatus === _types.InstallStatus.notInstalled || installationStatus === _types.InstallStatus.installing ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageInstallTitle",
    defaultMessage: "Install {title}",
    values: {
      title
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageInstallDescription",
    defaultMessage: "Install this integration to setup Kibana and Elasticsearch assets designed for {title} data.",
    values: {
      title
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_install_button.InstallButton, (0, _extends2.default)({}, packageInfo, {
    disabled: packageMetadata === null || packageMetadata === void 0 ? void 0 : packageMetadata.has_policies
  })))))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageUninstallTitle",
    defaultMessage: "Uninstall"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageUninstallDescription",
    defaultMessage: "Remove Kibana and Elasticsearch assets that were installed by this integration."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_uninstall_button.UninstallButton, (0, _extends2.default)({}, packageInfo, {
    latestVersion: latestVersion,
    disabled: packageMetadata === null || packageMetadata === void 0 ? void 0 : packageMetadata.has_policies
  })))), (packageMetadata === null || packageMetadata === void 0 ? void 0 : packageMetadata.has_policies) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageUninstallNoteDescription.packageUninstallNoteDetail",
    defaultMessage: "{strongNote} {title} cannot be uninstalled because there are active agents that use this integration. To uninstall, remove all {title} integrations from your agent policies.",
    values: {
      title,
      strongNote: /*#__PURE__*/_react.default.createElement(NoteLabel, null)
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageReinstallTitle",
    defaultMessage: "Reinstall"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageReinstallDescription",
    defaultMessage: "Reinstall Kibana and Elasticsearch assets for this integration."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_reinstall_button.ReinstallButton, (0, _extends2.default)({}, packageInfo, {
    installSource: 'installationInfo' in packageInfo && (_packageInfo$installa = packageInfo.installationInfo) !== null && _packageInfo$installa !== void 0 && _packageInfo$installa.install_source ? packageInfo.installationInfo.install_source : '',
    isCustomPackage: isCustomPackage
  }))))))), hideInstallOptions && isViewingOldPackage && !isUpdating && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageInstallTitle",
    defaultMessage: "Install {title}",
    values: {
      title
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageSettingsOldVersionMessage",
    defaultMessage: "Version {version} is out of date. The {latestVersion} of this integration is available to be installed.",
    values: {
      version,
      latestVersion: /*#__PURE__*/_react.default.createElement(LatestVersionLink, {
        name: name,
        version: latestVersion
      })
    }
  })))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, isChangelogModalOpen && /*#__PURE__*/_react.default.createElement(_changelog_modal.ChangelogModal, {
    changelog: changelog,
    isLoading: isChangelogLoading,
    onClose: toggleChangelogModal
  })), isBreakingChangesFlyoutOpen && breakingChanges && /*#__PURE__*/_react.default.createElement(_breaking_changes_flyout.BreakingChangesFlyout, {
    breakingChanges: breakingChanges,
    onClose: () => setIsBreakingChangesFlyoutOpen(false)
  }));
});