"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootPrivilegesCallout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RootPrivilegesCallout = ({
  dataStreams
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    color: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.requireRootCalloutTitle",
      defaultMessage: "Requires root privileges"
    }),
    "data-test-subj": "rootPrivilegesCallout"
  }, dataStreams.length === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.requireRootCalloutDescription",
    defaultMessage: "Elastic Agent needs to be run with root/administrator privileges for this integration."
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addIntegration.confirmModal.unprivilegedAgentsDataStreamsMessage",
    defaultMessage: "This integration has the following data streams that require Elastic Agents to have root privileges. To ensure that all data required by the integration can be collected, enroll agents using an account with root privileges.  For more information, see the {guideLink}",
    values: {
      guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.unprivilegedMode,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.addIntegration.confirmModal.unprivilegedAgentsDataStreamsMessage.guideLink",
        defaultMessage: "Fleet and Elastic Agent Guide"
      }))
    }
  }), /*#__PURE__*/_react.default.createElement("ul", null, dataStreams.map(item => /*#__PURE__*/_react.default.createElement("li", {
    key: item.name
  }, item.title)))));
};
exports.RootPrivilegesCallout = RootPrivilegesCallout;