"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStepStatus = (currentStep, stepIndex, currentStepComplete) => {
  if (currentStep === stepIndex) {
    if (currentStepComplete) return 'complete';
    return 'current';
  }
  if (currentStep > stepIndex) {
    return 'complete';
  }
  return 'incomplete';
};
const PageSteps = ({
  steps: stepTitles,
  currentStep = 0,
  currentStepComplete = false
}) => {
  const steps = stepTitles.map((title, index) => {
    return {
      title,
      status: getStepStatus(currentStep, index, currentStepComplete),
      onClick: () => {}
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    size: "xs",
    steps: steps
  });
};
exports.PageSteps = PageSteps;