"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeAction = executeAction;
exports.isActionCompatible = isActionCompatible;
var _public = require("@kbn/ui-actions-plugin/public");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function isActionCompatible(data) {
  const {
    query
  } = data;
  const currentQueryString = query.queryString.getQuery();
  // we want to make sure that the current query is an ES|QL query
  return currentQueryString && (0, _esQuery.isOfAggregateQueryType)(currentQueryString);
}
async function executeAction({
  queryString,
  data
}) {
  const isCompatibleAction = await isActionCompatible(data);
  if (!isCompatibleAction) {
    throw new _public.IncompatibleActionError();
  }
  const {
    query
  } = data;
  query.queryString.setQuery({
    esql: queryString
  });
}