"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FetchAnalyticsCollectionLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _fetch_analytics_collection_api_logic = require("../../api/fetch_analytics_collection/fetch_analytics_collection_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FetchAnalyticsCollectionLogic = exports.FetchAnalyticsCollectionLogic = (0, _kea.kea)({
  actions: {
    fetchAnalyticsCollection: name => ({
      name
    })
  },
  connect: {
    actions: [_fetch_analytics_collection_api_logic.FetchAnalyticsCollectionAPILogic, ['makeRequest', 'apiSuccess']],
    values: [_fetch_analytics_collection_api_logic.FetchAnalyticsCollectionAPILogic, ['data', 'status']]
  },
  listeners: ({
    actions
  }) => ({
    fetchAnalyticsCollection: ({
      name
    }) => {
      actions.makeRequest({
        name
      });
    }
  }),
  path: ['enterprise_search', 'analytics', 'collection'],
  selectors: ({
    selectors
  }) => ({
    analyticsCollection: [() => [selectors.data], data => data || null],
    isLoading: [() => [selectors.status], status => [_api.Status.LOADING, _api.Status.IDLE].includes(status)]
  })
});