"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeKbnUrlTracking = initializeKbnUrlTracking;
var _rxjs = require("rxjs");
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("@kbn/kibana-utils-plugin/common");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * It creates the kbn url tracker for Discover to listens to history changes and optionally to global state
 * changes and updates the nav link url of to point to the last visited page
 */
function initializeKbnUrlTracking({
  baseUrl,
  core,
  navLinkUpdater$,
  plugins,
  getScopedHistory
}) {
  /**
   * Store the setting of enabling / disabling url
   * it's should be disabled for ad-hoc data views (but enabled for ES|QL) to omit error messages
   * - When you've added an ad hoc data view in Discover
   * - Continued your work in different parts of Kibana
   * - You've closed the Kibana tab
   */
  let urlTrackingEnabled = true;
  const setTrackingEnabled = value => {
    urlTrackingEnabled = value;
  };
  const {
    appMounted,
    appUnMounted,
    stop: stopUrlTracker,
    setActiveUrl: setTrackedUrl,
    restorePreviousUrl
  } = (0, _public.createKbnUrlTracker)({
    // we pass getter here instead of plain `history`,
    // so history is lazily created (when app is mounted)
    // this prevents redundant `#` when not in discover app
    getHistory: getScopedHistory,
    baseUrl,
    defaultSubUrl: '#/',
    storageKey: `lastUrl:${core.http.basePath.get()}:discover`,
    navLinkUpdater$,
    toastNotifications: core.notifications.toasts,
    stateParams: [{
      kbnUrlKey: '_g',
      stateUpdate$: plugins.data.query.state$.pipe((0, _rxjs.filter)(({
        changes
      }) => !!(changes.globalFilters || changes.time || changes.refreshInterval)), (0, _rxjs.switchMap)(async ({
        state
      }) => {
        var _state$filters;
        const {
          isFilterPinned
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
        return {
          ...state,
          filters: (_state$filters = state.filters) === null || _state$filters === void 0 ? void 0 : _state$filters.filter(isFilterPinned)
        };
      }))
    }],
    shouldTrackUrlUpdate: () => {
      return urlTrackingEnabled;
    },
    onBeforeNavLinkSaved: newNavLink => {
      // Do not save SEARCH_SESSION_ID into nav link, because of possible edge cases
      // that could lead to session restoration failure.
      // see: https://github.com/elastic/kibana/issues/87149
      if (newNavLink.includes(_constants.SEARCH_SESSION_ID_QUERY_PARAM)) {
        newNavLink = (0, _common.replaceUrlHashQuery)(newNavLink, query => {
          delete query[_constants.SEARCH_SESSION_ID_QUERY_PARAM];
          return query;
        });
      }
      return newNavLink;
    }
  });
  return {
    appMounted,
    appUnMounted,
    stopUrlTracker,
    setTrackedUrl,
    restorePreviousUrl,
    setTrackingEnabled
  };
}