"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserAndSpaceIds = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getUserAndSpaceIds = async services => {
  let userId = '';
  let spaceId = '';
  try {
    var _await$services$core$, _services$core$securi;
    userId = (_await$services$core$ = (await ((_services$core$securi = services.core.security) === null || _services$core$securi === void 0 ? void 0 : _services$core$securi.authc.getCurrentUser())).profile_uid) !== null && _await$services$core$ !== void 0 ? _await$services$core$ : '';
  } catch {
    // ignore as user id might be unavailable for some deployments
  }
  try {
    var _await$services$space, _await$services$space2, _services$spaces;
    spaceId = (_await$services$space = (_await$services$space2 = await ((_services$spaces = services.spaces) === null || _services$spaces === void 0 ? void 0 : _services$spaces.getActiveSpace())) === null || _await$services$space2 === void 0 ? void 0 : _await$services$space2.id) !== null && _await$services$space !== void 0 ? _await$services$space : '';
  } catch {
    // ignore
  }
  return {
    userId,
    spaceId
  };
};
exports.getUserAndSpaceIds = getUserAndSpaceIds;