"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorState = ErrorState;
exports.LoadingState = LoadingState;
exports.NoDataState = NoDataState;
exports.TIME_LABELS = void 0;
exports.TimeLabelForData = TimeLabelForData;
exports.asPercent = asPercent;
exports.getDomain = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _chartIcons = require("@kbn/chart-icons");
var _public = require("@kbn/charts-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isFiniteNumber(value) {
  return isFinite(value);
}
function asPercent(numerator, denominator, fallbackResult = 'N/A') {
  if (!denominator || !isFiniteNumber(numerator)) {
    return fallbackResult;
  }
  const decimal = numerator / denominator;
  if (Math.abs(decimal) >= 0.1 || decimal === 0) {
    return (0, _numeral.default)(decimal).format('0.000%');
  }
  return (0, _numeral.default)(decimal).format('0.000%');
}
const TIME_LABELS = exports.TIME_LABELS = {
  s: _i18n.i18n.translate('xpack.datasetQuality.alerts.timeLabels.seconds', {
    defaultMessage: 'seconds'
  }),
  m: _i18n.i18n.translate('xpack.datasetQuality.alerts.timeLabels.minutes', {
    defaultMessage: 'minutes'
  }),
  h: _i18n.i18n.translate('xpack.datasetQuality.alerts.timeLabels.hours', {
    defaultMessage: 'hours'
  }),
  d: _i18n.i18n.translate('xpack.datasetQuality.alerts.timeLabels.days', {
    defaultMessage: 'days'
  })
};
const getDomain = series => {
  const xValues = series.flatMap(item => item.data.map(d => d.x));
  const yValues = series.flatMap(item => item.data.map(d => d.y || 0));
  return {
    xMax: Math.max(...xValues),
    xMin: Math.min(...xValues),
    yMax: Math.max(...yValues),
    yMin: Math.min(...yValues)
  };
};
exports.getDomain = getDomain;
const EmptyContainer = ({
  children
}) => /*#__PURE__*/_react.default.createElement("div", {
  style: {
    width: '100%',
    height: 150,
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center'
  }
}, children);
function NoDataState() {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, null, /*#__PURE__*/_react.default.createElement(_public.EmptyPlaceholder, {
    icon: _chartIcons.IconChartBar,
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.datasetQuality.chartPreview.noDataMessage",
      defaultMessage: "No results found"
    })
  }));
}
function LoadingState() {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "loadingData"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m"
  })));
}
function ErrorState() {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "chartErrorState"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.alerts.charts.errorMessage",
    defaultMessage: "Uh oh, something went wrong"
  })));
}
function TimeLabelForData({
  field,
  timeSize,
  timeUnit,
  series,
  totalGroups
}) {
  const totalGroupsTooltip = _i18n.i18n.translate('xpack.datasetQuality.chartPreview.TimeLabelForData.totalGroupsTooltip', {
    defaultMessage: 'Showing {series} out of {totalGroups} groups',
    values: {
      series,
      totalGroups
    }
  });
  const xAxisInfo = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.chartPreview.timeLabelForData.xAxis",
    defaultMessage: "{field} per {timeSize} {timeUnit}",
    values: {
      field,
      timeSize,
      timeUnit: TIME_LABELS[timeUnit]
    }
  })));
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'center'
    }
  }, totalGroups > series ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: totalGroupsTooltip,
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, xAxisInfo, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    color: "subdued",
    type: "question",
    className: "eui-alignTop"
  }))) : xAxisInfo);
}