"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataControlFieldRegistry = void 0;
var _lodash = require("lodash");
var _std = require("@kbn/std");
var _control_factory_registry = require("../../control_factory_registry");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDataControlFieldRegistry = exports.getDataControlFieldRegistry = (0, _lodash.memoize)(async dataView => {
  return await loadFieldRegistryFromDataView(dataView);
}, dataView => [dataView.id, JSON.stringify(dataView.fields.getAll())].join('|'));
const loadFieldRegistryFromDataView = async dataView => {
  const controlFactories = await (0, _std.asyncMap)((0, _control_factory_registry.getAllControlTypes)(), async controlType => (0, _control_factory_registry.getControlFactory)(controlType));
  const fieldRegistry = {};
  return new Promise(resolve => {
    for (const field of dataView.fields.getAll()) {
      const compatibleControlTypes = [];
      for (const factory of controlFactories) {
        if ((0, _types.isDataControlFactory)(factory) && factory.isFieldCompatible(field)) {
          compatibleControlTypes.push(factory.type);
        }
      }
      if (compatibleControlTypes.length > 0) {
        fieldRegistry[field.name] = {
          field,
          compatibleControlTypes
        };
      }
    }
    resolve(fieldRegistry);
  });
};