"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndex = fetchIndex;
var _searchConnectors = require("@kbn/search-connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchIndex(client, indexName) {
  const [indexDataResult, indexCountResult, connectorResult] = await Promise.allSettled([client.indices.get({
    index: indexName
  }), client.count({
    index: indexName
  }), (0, _searchConnectors.fetchConnectorByIndexName)(client, indexName)]);
  if (indexDataResult.status === 'rejected') {
    throw indexDataResult.reason;
  }
  const indexData = indexDataResult.value;
  if (!indexData || !indexData[indexName]) return undefined;
  const index = indexData[indexName];
  const count = indexCountResult.status === 'fulfilled' ? indexCountResult.value.count : 0;
  const connector = connectorResult.status === 'fulfilled' ? connectorResult.value : undefined;
  return {
    index: {
      ...index,
      count,
      connector
    }
  };
}