"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorNameAndDescriptionFormContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _connector_name_and_description_logic = require("./connector_name_and_description_logic");
var _translations = require("../../../connectors/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorNameAndDescriptionFormContent = () => {
  const {
    localNameAndDescription: {
      name,
      description
    }
  } = (0, _kea.useValues)(_connector_name_and_description_logic.ConnectorNameAndDescriptionLogic);
  const {
    updateLocalNameAndDescription
  } = (0, _kea.useActions)(_connector_name_and_description_logic.ConnectorNameAndDescriptionLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.NAME_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    required: true,
    value: name !== null && name !== void 0 ? name : '',
    onChange: event => {
      updateLocalNameAndDescription({
        name: event.target.value
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.DESCRIPTION_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    placeholder: _translations.OPTIONAL_LABEL,
    value: description || '',
    onChange: event => {
      updateLocalNameAndDescription({
        description: event.target.value
      });
    }
  })));
};
exports.ConnectorNameAndDescriptionFormContent = ConnectorNameAndDescriptionFormContent;