"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PersistableStateAndExternalReferencesLimiter = void 0;
var _domain = require("../../../../common/types/domain");
var _constants = require("../../../../common/constants");
var _utils = require("../../utils");
var _base_limiter = require("../base_limiter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PersistableStateAndExternalReferencesLimiter extends _base_limiter.BaseLimiter {
  constructor(attachmentService) {
    super({
      limit: _constants.MAX_PERSISTABLE_STATE_AND_EXTERNAL_REFERENCES,
      attachmentType: [_domain.AttachmentType.persistableState, _domain.AttachmentType.externalReference],
      attachmentNoun: 'persistable state and external reference attachments'
    });
    this.attachmentService = attachmentService;
  }
  async countOfItemsWithinCase(caseId) {
    return this.attachmentService.countPersistableStateAndExternalReferenceAttachments({
      caseId
    });
  }
  countOfItemsInRequest(requests) {
    const totalReferences = requests.filter(_utils.isPersistableStateOrExternalReference).filter(request => !(0, _utils.isFileAttachmentRequest)(request));
    return totalReferences.length;
  }
}
exports.PersistableStateAndExternalReferencesLimiter = PersistableStateAndExternalReferencesLimiter;