"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = exports.App = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _app = require("./components/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderApp = deps => {
  const {
    mountParams
  } = deps;
  const {
    element
  } = mountParams;
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(App, {
    deps: deps
  }), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;
const CasesAppWithContext = /*#__PURE__*/_react.default.memo(({
  externalReferenceAttachmentTypeRegistry,
  persistableStateAttachmentTypeRegistry,
  getFilesClient
}) => {
  return /*#__PURE__*/_react.default.createElement(_app.CasesApp, {
    externalReferenceAttachmentTypeRegistry: externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry: persistableStateAttachmentTypeRegistry,
    getFilesClient: getFilesClient
  });
});
CasesAppWithContext.displayName = 'CasesAppWithContext';
const App = ({
  deps
}) => {
  const {
    mountParams,
    coreStart,
    pluginsStart,
    storage,
    kibanaVersion
  } = deps;
  const {
    history
  } = mountParams;
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStart, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      kibanaVersion,
      ...coreStart,
      ...pluginsStart,
      storage
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(CasesAppWithContext, {
    externalReferenceAttachmentTypeRegistry: deps.externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry: deps.persistableStateAttachmentTypeRegistry,
    getFilesClient: pluginsStart.files.filesClientFactory.asScoped
  }))));
};
exports.App = App;
App.displayName = 'App';