"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLHeader = MLHeader;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _mlsingle_metric_link = require("../../links/machine_learning_links/mlsingle_metric_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShiftedIconWrapper = _styled.default.span`
  padding-right: 5px;
  position: relative;
  top: -1px;
  display: inline-block;
`;
const ShiftedEuiText = (0, _styled.default)(_eui.EuiText)`
  position: relative;
  top: 5px;
`;
function MLHeader({
  hasValidMlLicense,
  mlJobId
}) {
  const {
    transactionType,
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      kuery
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}', '/mobile-services/{serviceName}');
  if (!hasValidMlLicense || !mlJobId) {
    return null;
  }
  const hasKuery = !(0, _lodash.isEmpty)(kuery);
  const icon = hasKuery ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "aria-label": _i18n.i18n.translate('xpack.apm.mLHeader.euiIconTip.warningLabel', {
      defaultMessage: 'Warning'
    }),
    type: "warning",
    color: "warning",
    content: _i18n.i18n.translate('xpack.apm.metrics.transactionChart.machineLearningTooltip.withKuery', {
      defaultMessage: 'The Machine learning results are hidden when the search bar is used for filtering'
    })
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.apm.metrics.transactionChart.machineLearningTooltip', {
      defaultMessage: 'The stream displays the expected bounds of the average latency. A red vertical annotation indicates anomalies with an anomaly score of 75 or above.'
    })
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ShiftedEuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(ShiftedIconWrapper, null, icon), /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.apm.metrics.transactionChart.machineLearningLabel', {
    defaultMessage: 'Machine learning:'
  }), ' '), /*#__PURE__*/_react.default.createElement(_mlsingle_metric_link.MLSingleMetricLink, {
    jobId: mlJobId,
    serviceName: serviceName,
    transactionType: transactionType
  }, _i18n.i18n.translate('xpack.apm.metrics.transactionChart.viewJob', {
    defaultMessage: 'View Job'
  }))));
}