"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMinMax = getMinMax;
exports.minMax$ = minMax$;
var _rxjs = require("rxjs");
var _kibana_services = require("../../../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function minMax$({
  controlFetch$,
  controlGroupApi,
  dataViews$,
  fieldName$,
  setIsLoading
}) {
  let prevRequestAbortController;
  return (0, _rxjs.combineLatest)([controlFetch$, dataViews$, fieldName$]).pipe((0, _rxjs.tap)(() => {
    if (prevRequestAbortController) {
      prevRequestAbortController.abort();
      prevRequestAbortController = undefined;
    }
  }), (0, _rxjs.switchMap)(async ([controlFetchContext, dataViews, fieldName]) => {
    const dataView = dataViews === null || dataViews === void 0 ? void 0 : dataViews[0];
    const dataViewField = dataView && fieldName ? dataView.getFieldByName(fieldName) : undefined;
    if (!dataView || !dataViewField) {
      return {
        max: undefined,
        min: undefined
      };
    }
    try {
      setIsLoading(true);
      const abortController = new AbortController();
      prevRequestAbortController = abortController;
      return await getMinMax({
        abortSignal: abortController.signal,
        dataView,
        field: dataViewField,
        ...controlFetchContext
      });
    } catch (error) {
      return {
        error,
        max: undefined,
        min: undefined
      };
    }
  }), (0, _rxjs.tap)(() => {
    setIsLoading(false);
  }));
}
async function getMinMax({
  abortSignal,
  dataView,
  field,
  filters,
  query,
  timeRange
}) {
  var _value, _resp$rawResponse, _resp$rawResponse$agg, _resp$rawResponse$agg2, _value2, _resp$rawResponse2, _resp$rawResponse2$ag, _resp$rawResponse2$ag2;
  const searchSource = await _kibana_services.dataService.search.searchSource.create();
  searchSource.setField('size', 0);
  searchSource.setField('index', dataView);
  const allFilters = filters ? [...filters] : [];
  if (timeRange) {
    const timeFilter = _kibana_services.dataService.query.timefilter.timefilter.createFilter(dataView, timeRange);
    if (timeFilter) allFilters.push(timeFilter);
  }
  if (allFilters.length) {
    searchSource.setField('filter', allFilters);
  }
  if (query) {
    searchSource.setField('query', query);
  }
  const aggBody = {};
  if (field.scripted) {
    aggBody.script = {
      source: field.script,
      lang: field.lang
    };
  } else {
    aggBody.field = field.name;
  }
  const aggs = {
    maxAgg: {
      max: aggBody
    },
    minAgg: {
      min: aggBody
    }
  };
  searchSource.setField('aggs', aggs);
  const resp = await (0, _rxjs.lastValueFrom)(searchSource.fetch$({
    abortSignal
  }));
  return {
    min: (_value = (_resp$rawResponse = resp.rawResponse) === null || _resp$rawResponse === void 0 ? void 0 : (_resp$rawResponse$agg = _resp$rawResponse.aggregations) === null || _resp$rawResponse$agg === void 0 ? void 0 : (_resp$rawResponse$agg2 = _resp$rawResponse$agg.minAgg) === null || _resp$rawResponse$agg2 === void 0 ? void 0 : _resp$rawResponse$agg2.value) !== null && _value !== void 0 ? _value : undefined,
    max: (_value2 = (_resp$rawResponse2 = resp.rawResponse) === null || _resp$rawResponse2 === void 0 ? void 0 : (_resp$rawResponse2$ag = _resp$rawResponse2.aggregations) === null || _resp$rawResponse2$ag === void 0 ? void 0 : (_resp$rawResponse2$ag2 = _resp$rawResponse2$ag.maxAgg) === null || _resp$rawResponse2$ag2 === void 0 ? void 0 : _resp$rawResponse2$ag2.value) !== null && _value2 !== void 0 ? _value2 : undefined
  };
}