"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupTechnologySelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/fleet-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _test_subjects = require("../../test_subjects");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SetupTechnologySelector = ({
  disabled,
  isAgentless,
  onSetupTechnologyChange,
  showLimitationsMessage = true
}) => {
  const radioGroupItemId1 = (0, _eui.useGeneratedHtmlId)({
    prefix: 'radioGroupItem',
    suffix: 'agentless'
  });
  const radioGroupItemId2 = (0, _eui.useGeneratedHtmlId)({
    prefix: 'radioGroupItem',
    suffix: 'agentbased'
  });
  const radioOptions = [{
    id: radioGroupItemId1,
    value: _public.SetupTechnology.AGENTLESS,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.setupTechnology.agentlessRadioLabel",
      defaultMessage: "Agentless"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.setupTechnology.agentBasedRadioDescription",
      defaultMessage: "Setup integration without an agent"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }))
  }, {
    id: radioGroupItemId2,
    value: _public.SetupTechnology.AGENT_BASED,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.setupTechnology.agentBasedRadioLabel",
      defaultMessage: "Agent-based"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.setupTechnology.agentBasedRadioDescription",
      defaultMessage: "Deploy an Elastic Agent into your cloud environment"
    }))))
  }];
  const [radioIdSelected, setRadioIdSelected] = (0, _react.useState)(isAgentless ? radioGroupItemId1 : radioGroupItemId2);
  (0, _react.useEffect)(() => {
    setRadioIdSelected(isAgentless ? radioGroupItemId1 : radioGroupItemId2);
  }, [isAgentless, radioGroupItemId1, radioGroupItemId2, setRadioIdSelected]);
  const onChange = optionId => {
    setRadioIdSelected(optionId);
    onSetupTechnologyChange(optionId === radioGroupItemId1 ? _public.SetupTechnology.AGENTLESS : _public.SetupTechnology.AGENT_BASED);
  };
  const limitationsMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.setupTechnologySelector.comingSoon",
    defaultMessage: "Agentless deployment is not supported if you are using {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/cloud-enterprise/current/ece-traffic-filtering-deployment-configuration.html",
        target: "_blank"
      }, "Traffic filtering")
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.setupTechnologySelector.deploymentOptionsTitle",
    defaultMessage: "Deployment options"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), showLimitationsMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: limitationsMessage,
    color: "warning",
    iconType: "alert",
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    disabled: disabled,
    "data-test-subj": _test_subjects.SETUP_TECHNOLOGY_SELECTOR_TEST_SUBJ,
    options: radioOptions,
    idSelected: radioIdSelected,
    onChange: id => onChange(id),
    name: "radio group"
  }));
};
exports.SetupTechnologySelector = SetupTechnologySelector;