"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateTags = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TemplateTagsComponent = ({
  isLoading,
  tagOptions
}) => {
  const options = tagOptions.map(label => ({
    label
  }));
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "templateTags",
    component: _components.ComboBoxField,
    componentProps: {
      idAria: 'template-tags',
      'data-test-subj': 'template-tags',
      euiFieldProps: {
        placeholder: '',
        fullWidth: true,
        disabled: isLoading,
        isLoading,
        options,
        noSuggestions: false,
        customOptionText: i18n.ADD_TAG_CUSTOM_OPTION_LABEL_COMBO_BOX
      }
    }
  });
};
TemplateTagsComponent.displayName = 'TemplateTagsComponent';
const TemplateTags = exports.TemplateTags = /*#__PURE__*/(0, _react.memo)(TemplateTagsComponent);