"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionFilterComponent = exports.SolutionFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _multi_select_filter = require("./multi_select_filter");
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isValidSolution = solution => Object.keys(_constants.OWNER_INFO).includes(solution);
const mapToReadableSolutionName = solution => {
  if (isValidSolution(solution)) {
    return _constants.OWNER_INFO[solution];
  }
  return {
    id: solution,
    label: solution,
    iconType: ''
  };
};
const SolutionFilterComponent = ({
  onChange,
  selectedOptionKeys,
  availableSolutions
}) => {
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const hasOwner = Boolean(owner.length);
  const options = (0, _multi_select_filter.mapToMultiSelectOption)(hasOwner ? owner : availableSolutions);
  const solutions = availableSolutions.map(solution => mapToReadableSolutionName(solution));
  const renderOption = option => {
    const solution = solutions.find(solutionData => solutionData.id === option.label);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "flexStart",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: solution.iconType,
      title: solution.label
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, solution.label));
  };
  return /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
    buttonLabel: i18n.SOLUTION,
    id: 'owner',
    onChange: onChange,
    options: options,
    renderOption: renderOption,
    selectedOptionKeys: selectedOptionKeys,
    isLoading: false
  });
};
exports.SolutionFilterComponent = SolutionFilterComponent;
SolutionFilterComponent.displayName = 'SolutionFilterComponent';
const SolutionFilter = exports.SolutionFilter = /*#__PURE__*/_react.default.memo(SolutionFilterComponent);
SolutionFilter.displayName = 'SolutionFilter';