"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWorkpadHistory = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _history = require("history");
var _route_state = require("../route_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useWorkpadHistory = () => {
  const history = (0, _reactRouterDom.useHistory)();
  const historyState = (0, _reactRedux.useSelector)(state => state.persistent);
  const hasRun = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    const isInitialRun = !hasRun.current;
    const locationState = history.location.state;
    const decodedState = locationState ? (0, _route_state.decode)(locationState) : {};
    const doesStateMatchLocationState = (0, _lodash.isEqual)(historyState, decodedState);
    const fullPath = (0, _history.createPath)(history.location);
    hasRun.current = true;

    // If there is no location state, then let's replace the curent route with the location state
    // This will happen when navigating directly to a url (there will be no state on that link click)
    if (locationState === undefined) {
      history.replace(fullPath, (0, _route_state.encode)(historyState));
    } else if (!isInitialRun && !doesStateMatchLocationState) {
      // There was a state change here
      // If the state of the route that we are on does not match this new state, then we are going to push
      history.push(fullPath, (0, _route_state.encode)(historyState));
    }
  }, [history, historyState, history.location.search]);
};
exports.useWorkpadHistory = useWorkpadHistory;