"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleUpdateProgramOauth2 = handleUpdateProgramOauth2;
var _output_parsers = require("@langchain/core/output_parsers");
var _constants = require("./constants");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleUpdateProgramOauth2({
  state,
  model
}) {
  const outputParser = new _output_parsers.StringOutputParser();
  const updateCelProgramHeadersGraph = _prompts.CEL_AUTH_OAUTH2_PROMPT.pipe(model).pipe(outputParser);
  const updatedProgram = await updateCelProgramHeadersGraph.invoke({
    cel_program: state.currentProgram,
    open_api_auth_schema: state.openApiAuthSchema,
    example_cel_programs: _constants.SAMPLE_CEL_PROGRAMS_OAUTH
  });
  return {
    currentProgram: updatedProgram.trim(),
    lastExecutedChain: 'updateProgramOAuth2'
  };
}