"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventMetadataRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _get_event_metadata = require("./get_event_metadata");
var _processor_event = require("../../../common/processor_event");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _default_api_types = require("../default_api_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const eventMetadataRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/event_metadata/{processorEvent}/{id}',
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  params: t.type({
    path: t.type({
      processorEvent: _processor_event.processorEventRt,
      id: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      start,
      end
    } = params.query;
    const {
      processorEvent,
      id
    } = params.path;
    const metadata = await (0, _get_event_metadata.getEventMetadata)({
      apmEventClient,
      processorEvent,
      id,
      start,
      end
    });
    return {
      metadata
    };
  }
});
const eventMetadataRouteRepository = exports.eventMetadataRouteRepository = eventMetadataRoute;