/**
 * A constant storing the `prefers-reduced-motion` media query
 * so that when it is turned off, animations are not run.
 */
export const euiCanAnimate = '@media screen and (prefers-reduced-motion: no-preference)';
/**
 * A constant storing the `prefers-reduced-motion` media query that will
 * only apply the content if the setting is off (reduce).
 */
export const euiCantAnimate = '@media screen and (prefers-reduced-motion: reduce)';
/**
 * Speeds / Durations / Delays
 */
export const EuiThemeAnimationSpeeds = [
    'extraFast',
    'fast',
    'normal',
    'slow',
    'extraSlow',
];
/**
 * Easings / Timing functions
 */
export const EuiThemeAnimationEasings = ['bounce', 'resistance'];
