"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAnglesBySize = getAnglesBySize;
exports.getAngledChartSizing = getAngledChartSizing;
const constants_1 = require("../../../common/constants");
const common_1 = require("../../../utils/common");
const constants_2 = require("../renderer/canvas/constants");
const spec_1 = require("../spec");
const theme_1 = require("../theme");
const sizeAngles = {
    [spec_1.BulletSubtype.halfCircle]: {
        startAngle: 1 * Math.PI,
        endAngle: 0,
    },
    [spec_1.BulletSubtype.twoThirdsCircle]: {
        startAngle: 1.25 * Math.PI,
        endAngle: -0.25 * Math.PI,
    },
    [spec_1.BulletSubtype.circle]: {
        startAngle: 1.5 * Math.PI,
        endAngle: -0.5 * Math.PI,
    },
};
function getAnglesBySize(subtype) {
    if (subtype === spec_1.BulletSubtype.vertical || subtype === spec_1.BulletSubtype.horizontal) {
        throw new Error('Attempting to retrieve angle size from horizontal/vertical bullet');
    }
    const angles = sizeAngles[subtype] ?? sizeAngles[spec_1.BulletSubtype.twoThirdsCircle];
    const startAngle = -angles.startAngle;
    const endAngle = (0, common_1.clamp)(-angles.endAngle, startAngle - constants_1.TAU, startAngle + constants_1.TAU);
    return [startAngle, endAngle];
}
const heightModifiers = {
    [spec_1.BulletSubtype.halfCircle]: 0.5,
    [spec_1.BulletSubtype.twoThirdsCircle]: 0.86,
    [spec_1.BulletSubtype.circle]: 1,
};
function getAngledChartSizing(graphSize, subtype) {
    if (subtype === spec_1.BulletSubtype.vertical || subtype === spec_1.BulletSubtype.horizontal) {
        throw new Error('Attempting to retrieve angle size from horizontal/vertical bullet');
    }
    const heightModifier = heightModifiers[subtype] ?? 1;
    const maxWidth = graphSize.width - theme_1.GRAPH_PADDING.left - theme_1.GRAPH_PADDING.right;
    const maxHeight = graphSize.height - theme_1.GRAPH_PADDING.top - theme_1.GRAPH_PADDING.bottom;
    const modifiedHeight = maxHeight / heightModifier;
    const radius = Math.min(maxWidth, modifiedHeight) / 2 - constants_2.TARGET_SIZE / 2;
    return { maxWidth, maxHeight: modifiedHeight, radius };
}
//# sourceMappingURL=angular.js.map