"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMSearchRequestHeader = exports.getMSearchRequestBody = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMSearchRequestHeader = indexName => ({
  expand_wildcards: ['open'],
  index: indexName
});
exports.getMSearchRequestHeader = getMSearchRequestHeader;
const getMSearchRequestBody = ({
  indexName,
  indexFieldName,
  allowedValues
}) => ({
  aggregations: {
    [indexFieldName]: {
      terms: {
        field: indexFieldName,
        order: {
          _count: 'desc'
        }
      }
    }
  },
  query: {
    bool: {
      filter: [{
        bool: {
          must: [],
          filter: [],
          should: [],
          must_not: allowedValues.length > 0 ? [{
            bool: {
              should: allowedValues.map(allowedValue => ({
                match_phrase: {
                  [indexFieldName]: allowedValue
                }
              })),
              minimum_should_match: 1
            }
          }] : []
        }
      }]
    }
  },
  runtime_mappings: {},
  size: 0
});
exports.getMSearchRequestBody = getMSearchRequestBody;