"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.singleDocLocatorGetLocation = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const singleDocLocatorGetLocation = async (...[params]) => {
  const {
    index,
    rowId,
    rowIndex,
    referrer
  } = params;
  let dataViewId;
  const state = {
    referrer
  };
  if (typeof index === 'object') {
    state.dataViewSpec = index;
    dataViewId = index.id;
  } else {
    dataViewId = index;
  }
  const path = `#/doc/${dataViewId}/${rowIndex}?id=${encodeURIComponent(rowId)}`;
  return {
    app: 'discover',
    path,
    state
  };
};
exports.singleDocLocatorGetLocation = singleDocLocatorGetLocation;