"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSideEffectFunction = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const collectSideEffectsData = adapters => {
  var _adapters$requests;
  return (_adapters$requests = adapters.requests) === null || _adapters$requests === void 0 ? void 0 : _adapters$requests.getRequestEntries();
};
const getSideEffectFunction = adapters => {
  const requestsWithResponses = collectSideEffectsData(adapters);
  return () => {
    var _adapters$requests2;
    if (!requestsWithResponses || requestsWithResponses.length === 0) {
      return;
    }
    const requestsMap = new Map(requestsWithResponses.map(([request]) => [request.id, request]));
    const responsesMap = new WeakMap(requestsWithResponses);
    (_adapters$requests2 = adapters.requests) === null || _adapters$requests2 === void 0 ? void 0 : _adapters$requests2.loadFromEntries(requestsMap, responsesMap);
  };
};
exports.getSideEffectFunction = getSideEffectFunction;