"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderTopBanner = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _header_extension = require("./header_extension");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const HeaderTopBanner = ({
  headerBanner$
}) => {
  const headerBanner = (0, _useObservable.default)(headerBanner$, undefined);
  if (!headerBanner) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "header__topBanner",
    "data-test-subj": "headerTopBanner"
  }, /*#__PURE__*/_react.default.createElement(_header_extension.HeaderExtension, {
    containerClassName: "header__topBannerContainer",
    display: "block",
    extension: headerBanner.content
  }));
};
exports.HeaderTopBanner = HeaderTopBanner;